/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster.router.mesh.rule.virtualservice;

import java.util.Map;
import java.util.Set;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.cluster.router.mesh.rule.virtualservice.match.DubboAttachmentMatch;
import org.apache.dubbo.rpc.cluster.router.mesh.rule.virtualservice.match.DubboMethodMatch;
import org.apache.dubbo.rpc.cluster.router.mesh.rule.virtualservice.match.StringMatch;
import org.apache.dubbo.rpc.cluster.router.mesh.util.TracingContextProvider;

public class DubboMatchRequest {
    private String name;
    private DubboMethodMatch method;
    private Map<String, String> sourceLabels;
    private DubboAttachmentMatch attachments;
    private Map<String, StringMatch> headers;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public DubboMethodMatch getMethod() {
        return this.method;
    }

    public void setMethod(DubboMethodMatch method) {
        this.method = method;
    }

    public Map<String, String> getSourceLabels() {
        return this.sourceLabels;
    }

    public void setSourceLabels(Map<String, String> sourceLabels) {
        this.sourceLabels = sourceLabels;
    }

    public DubboAttachmentMatch getAttachments() {
        return this.attachments;
    }

    public void setAttachments(DubboAttachmentMatch attachments) {
        this.attachments = attachments;
    }

    public Map<String, StringMatch> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, StringMatch> headers) {
        this.headers = headers;
    }

    public String toString() {
        return "DubboMatchRequest{name='" + this.name + '\'' + ", method=" + this.method + ", sourceLabels=" + this.sourceLabels + ", attachments=" + this.attachments + ", headers=" + this.headers + '}';
    }

    public boolean isMatch(Invocation invocation, Map<String, String> sourceLabels, Set<TracingContextProvider> contextProviders) {
        if (this.getMethod() != null && !this.getMethod().isMatch(invocation)) {
            return false;
        }
        if (this.getSourceLabels() != null) {
            for (Map.Entry<String, String> entry : this.getSourceLabels().entrySet()) {
                String value = sourceLabels.get(entry.getKey());
                if (entry.getValue().equals(value)) continue;
                return false;
            }
        }
        if (this.getAttachments() != null) {
            return this.getAttachments().isMatch(invocation, contextProviders);
        }
        return true;
    }
}

