/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster.router.condition.config.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.cluster.router.condition.config.model.Destination;
import org.apache.dubbo.rpc.cluster.router.state.BitList;

public class DestinationSet<T> {
    private final List<Destination<T>> destinations = new ArrayList<Destination<T>>();
    private long weightSum = 0L;
    private final ThreadLocalRandom random = ThreadLocalRandom.current();

    public void addDestination(int weight, BitList<Invoker<T>> invokers) {
        this.destinations.add(new Destination<T>(weight, invokers));
        this.weightSum += (long)weight;
    }

    public BitList<Invoker<T>> randDestination() {
        if (this.destinations.size() == 1) {
            return this.destinations.get(0).getInvokers();
        }
        long sum = this.random.nextLong(this.weightSum);
        for (Destination<T> destination : this.destinations) {
            if ((sum -= (long)destination.getWeight()) > 0L) continue;
            return destination.getInvokers();
        }
        return BitList.emptyList();
    }

    public List<Destination<T>> getDestinations() {
        return this.destinations;
    }

    public long getWeightSum() {
        return this.weightSum;
    }

    public void setWeightSum(long weightSum) {
        this.weightSum = weightSum;
    }

    public Random getRandom() {
        return this.random;
    }
}

