/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.threadpool.manager;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.constants.CommonConstants;
import org.apache.dubbo.common.extension.ExtensionAccessor;
import org.apache.dubbo.common.extension.ExtensionAccessorAware;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.threadlocal.NamedInternalThreadFactory;
import org.apache.dubbo.common.threadpool.ThreadPool;
import org.apache.dubbo.common.threadpool.manager.ExecutorRepository;
import org.apache.dubbo.common.threadpool.manager.Ring;
import org.apache.dubbo.common.utils.ExecutorUtil;
import org.apache.dubbo.common.utils.NamedThreadFactory;
import org.apache.dubbo.config.ConsumerConfig;
import org.apache.dubbo.config.ModuleConfig;
import org.apache.dubbo.config.ProviderConfig;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.ModuleModel;
import org.apache.dubbo.rpc.model.ScopeModelAware;

public class DefaultExecutorRepository
implements ExecutorRepository,
ExtensionAccessorAware,
ScopeModelAware {
    private static final Logger logger = LoggerFactory.getLogger(DefaultExecutorRepository.class);
    private int DEFAULT_SCHEDULER_SIZE = Runtime.getRuntime().availableProcessors();
    private final ExecutorService sharedExecutor;
    private final ScheduledExecutorService sharedScheduledExecutor;
    private Ring<ScheduledExecutorService> scheduledExecutors = new Ring();
    private volatile ScheduledExecutorService serviceExportExecutor;
    private volatile ExecutorService serviceReferExecutor;
    private ScheduledExecutorService connectivityScheduledExecutor;
    public Ring<ScheduledExecutorService> registryNotificationExecutorRing = new Ring();
    private Ring<ScheduledExecutorService> serviceDiscoveryAddressNotificationExecutorRing = new Ring();
    private ScheduledExecutorService metadataRetryExecutor;
    private ConcurrentMap<String, ConcurrentMap<Integer, ExecutorService>> data = new ConcurrentHashMap<String, ConcurrentMap<Integer, ExecutorService>>();
    private ExecutorService poolRouterExecutor;
    private Ring<ExecutorService> executorServiceRing = new Ring();
    private final Object LOCK = new Object();
    private ExtensionAccessor extensionAccessor;
    private ApplicationModel applicationModel;

    public DefaultExecutorRepository() {
        int i;
        this.sharedExecutor = Executors.newCachedThreadPool(new NamedThreadFactory("Dubbo-shared-handler", true));
        this.sharedScheduledExecutor = Executors.newScheduledThreadPool(8, new NamedThreadFactory("Dubbo-shared-scheduler", true));
        for (i = 0; i < this.DEFAULT_SCHEDULER_SIZE; ++i) {
            ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor(new NamedThreadFactory("Dubbo-framework-scheduler-" + i, true));
            this.scheduledExecutors.addItem(scheduler);
            this.executorServiceRing.addItem(new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(1024), new NamedInternalThreadFactory("Dubbo-state-router-loop-" + i, true), new ThreadPoolExecutor.AbortPolicy()));
        }
        this.connectivityScheduledExecutor = Executors.newScheduledThreadPool(this.DEFAULT_SCHEDULER_SIZE, new NamedThreadFactory("Dubbo-connectivity-scheduler", true));
        this.poolRouterExecutor = new ThreadPoolExecutor(1, 10, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(1024), new NamedInternalThreadFactory("Dubbo-state-router-pool-router", true), new ThreadPoolExecutor.AbortPolicy());
        for (i = 0; i < this.DEFAULT_SCHEDULER_SIZE; ++i) {
            ScheduledExecutorService serviceDiscoveryAddressNotificationExecutor = Executors.newSingleThreadScheduledExecutor(new NamedThreadFactory("Dubbo-SD-address-refresh-" + i));
            ScheduledExecutorService registryNotificationExecutor = Executors.newSingleThreadScheduledExecutor(new NamedThreadFactory("Dubbo-registry-notification-" + i));
            this.serviceDiscoveryAddressNotificationExecutorRing.addItem(serviceDiscoveryAddressNotificationExecutor);
            this.registryNotificationExecutorRing.addItem(registryNotificationExecutor);
        }
        this.metadataRetryExecutor = Executors.newSingleThreadScheduledExecutor(new NamedThreadFactory("Dubbo-metadata-retry"));
    }

    @Override
    public synchronized ExecutorService createExecutorIfAbsent(URL url) {
        URL finalUrl;
        ExecutorService executor;
        Map executors = this.data.computeIfAbsent(CommonConstants.EXECUTOR_SERVICE_COMPONENT_KEY, k -> new ConcurrentHashMap());
        Integer portKey = "consumer".equalsIgnoreCase(url.getParameter("side")) ? Integer.MAX_VALUE : url.getPort();
        if (url.getParameter("threadname") == null) {
            url = url.putAttribute("threadname", "Dubbo-protocol-" + portKey);
        }
        if ((executor = executors.computeIfAbsent(portKey, arg_0 -> this.lambda$createExecutorIfAbsent$1(finalUrl = url, arg_0))).isShutdown() || executor.isTerminated()) {
            executors.remove(portKey);
            executor = this.createExecutor(url);
            executors.put(portKey, executor);
        }
        return executor;
    }

    @Override
    public ExecutorService getExecutor(URL url) {
        Map executors = (Map)this.data.get(CommonConstants.EXECUTOR_SERVICE_COMPONENT_KEY);
        if (executors == null) {
            logger.warn("No available executors, this is not expected, framework should call createExecutorIfAbsent first before coming to here.");
            return null;
        }
        Integer portKey = "consumer".equalsIgnoreCase(url.getParameter("side")) ? Integer.MAX_VALUE : url.getPort();
        ExecutorService executor = (ExecutorService)executors.get(portKey);
        if (executor != null && (executor.isShutdown() || executor.isTerminated())) {
            executors.remove(portKey);
            executor = null;
            logger.info("Executor for " + url + " is shutdown.");
        }
        if (executor == null) {
            return this.sharedExecutor;
        }
        return executor;
    }

    @Override
    public void updateThreadpool(URL url, ExecutorService executor) {
        try {
            if (url.hasParameter("threads") && executor instanceof ThreadPoolExecutor && !executor.isShutdown()) {
                ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor)executor;
                int threads = url.getParameter("threads", 0);
                int max = threadPoolExecutor.getMaximumPoolSize();
                int core = threadPoolExecutor.getCorePoolSize();
                if (threads > 0 && (threads != max || threads != core)) {
                    if (threads < core) {
                        threadPoolExecutor.setCorePoolSize(threads);
                        if (core == max) {
                            threadPoolExecutor.setMaximumPoolSize(threads);
                        }
                    } else {
                        threadPoolExecutor.setMaximumPoolSize(threads);
                        if (core == max) {
                            threadPoolExecutor.setCorePoolSize(threads);
                        }
                    }
                }
            }
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
        }
    }

    @Override
    public ScheduledExecutorService nextScheduledExecutor() {
        return this.scheduledExecutors.pollItem();
    }

    @Override
    public ExecutorService nextExecutorExecutor() {
        return this.executorServiceRing.pollItem();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScheduledExecutorService getServiceExportExecutor() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.serviceExportExecutor == null) {
                int coreSize = this.getExportThreadNum();
                this.serviceExportExecutor = Executors.newScheduledThreadPool(coreSize, new NamedThreadFactory("Dubbo-service-export", true));
            }
        }
        return this.serviceExportExecutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdownServiceExportExecutor() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.serviceExportExecutor != null && !this.serviceExportExecutor.isShutdown()) {
                try {
                    this.serviceExportExecutor.shutdown();
                }
                catch (Throwable ignored) {
                    logger.warn(ignored.getMessage(), ignored);
                }
            }
            this.serviceExportExecutor = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExecutorService getServiceReferExecutor() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.serviceReferExecutor == null) {
                int coreSize = this.getReferThreadNum();
                this.serviceReferExecutor = Executors.newFixedThreadPool(coreSize, new NamedThreadFactory("Dubbo-service-refer", true));
            }
        }
        return this.serviceReferExecutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdownServiceReferExecutor() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.serviceReferExecutor != null && !this.serviceReferExecutor.isShutdown()) {
                try {
                    this.serviceReferExecutor.shutdown();
                }
                catch (Throwable ignored) {
                    logger.warn(ignored.getMessage(), ignored);
                }
            }
            this.serviceReferExecutor = null;
        }
    }

    private Integer getExportThreadNum() {
        ModuleModel moduleModel;
        Integer threadNum = null;
        ApplicationModel applicationModel = ApplicationModel.ofNullable(this.applicationModel);
        Iterator<ModuleModel> iterator = applicationModel.getPubModuleModels().iterator();
        while (iterator.hasNext() && (threadNum = this.getExportThreadNum(moduleModel = iterator.next())) == null) {
        }
        if (threadNum == null) {
            logger.info("Cannot get config `export-thread-num` from module config, using default: 10");
            return 10;
        }
        return threadNum;
    }

    private Integer getExportThreadNum(ModuleModel moduleModel) {
        ModuleConfig moduleConfig = moduleModel.getConfigManager().getModule().orElse(null);
        if (moduleConfig == null) {
            return null;
        }
        Integer threadNum = moduleConfig.getExportThreadNum();
        if (threadNum == null) {
            threadNum = moduleModel.getConfigManager().getProviders().stream().map(ProviderConfig::getExportThreadNum).filter(k -> k != null && k > 0).findAny().orElse(null);
        }
        return threadNum;
    }

    private Integer getReferThreadNum() {
        ModuleModel moduleModel;
        Integer threadNum = null;
        ApplicationModel applicationModel = ApplicationModel.ofNullable(this.applicationModel);
        Iterator<ModuleModel> iterator = applicationModel.getPubModuleModels().iterator();
        while (iterator.hasNext() && (threadNum = this.getReferThreadNum(moduleModel = iterator.next())) == null) {
        }
        if (threadNum == null) {
            logger.info("Cannot get config `refer-thread-num` from module config, using default: 10");
            return 10;
        }
        return threadNum;
    }

    private Integer getReferThreadNum(ModuleModel moduleModel) {
        ModuleConfig moduleConfig = moduleModel.getConfigManager().getModule().orElse(null);
        if (moduleConfig == null) {
            return null;
        }
        Integer threadNum = moduleConfig.getReferThreadNum();
        if (threadNum == null) {
            threadNum = moduleModel.getConfigManager().getConsumers().stream().map(ConsumerConfig::getReferThreadNum).filter(k -> k != null && k > 0).findAny().orElse(null);
        }
        return threadNum;
    }

    @Override
    public ScheduledExecutorService getRegistryNotificationExecutor() {
        return this.registryNotificationExecutorRing.pollItem();
    }

    @Override
    public ScheduledExecutorService getServiceDiscoveryAddressNotificationExecutor() {
        return this.serviceDiscoveryAddressNotificationExecutorRing.pollItem();
    }

    @Override
    public ScheduledExecutorService getMetadataRetryExecutor() {
        return this.metadataRetryExecutor;
    }

    @Override
    public ExecutorService getSharedExecutor() {
        return this.sharedExecutor;
    }

    @Override
    public ScheduledExecutorService getSharedScheduledExecutor() {
        return this.sharedScheduledExecutor;
    }

    private ExecutorService createExecutor(URL url) {
        return (ExecutorService)this.extensionAccessor.getExtensionLoader(ThreadPool.class).getAdaptiveExtension().getExecutor(url);
    }

    @Override
    public ExecutorService getPoolRouterExecutor() {
        return this.poolRouterExecutor;
    }

    @Override
    public ScheduledExecutorService getConnectivityScheduledExecutor() {
        return this.connectivityScheduledExecutor;
    }

    @Override
    public void destroyAll() {
        logger.info("destroying executor repository ..");
        this.shutdownExecutorService(this.poolRouterExecutor, "poolRouterExecutor");
        this.shutdownExecutorService(this.metadataRetryExecutor, "metadataRetryExecutor");
        this.shutdownServiceExportExecutor();
        this.shutdownServiceReferExecutor();
        this.data.values().forEach(executors -> {
            if (executors != null) {
                executors.values().forEach(executor -> {
                    if (executor != null && !executor.isShutdown()) {
                        try {
                            ExecutorUtil.shutdownNow(executor, 100);
                        }
                        catch (Throwable ignored) {
                            logger.warn(ignored.getMessage(), ignored);
                        }
                    }
                });
            }
        });
        this.data.clear();
        this.shutdownExecutorServices(this.scheduledExecutors.listItems(), "scheduledExecutors");
        this.shutdownExecutorServices(this.executorServiceRing.listItems(), "executorServiceRing");
        this.shutdownExecutorService(this.connectivityScheduledExecutor, "connectivityScheduledExecutor");
        this.shutdownExecutorService(this.sharedExecutor, "sharedExecutor");
        this.shutdownExecutorService(this.sharedScheduledExecutor, "sharedScheduledExecutor");
        this.shutdownExecutorServices(this.serviceDiscoveryAddressNotificationExecutorRing.listItems(), "serviceDiscoveryAddressNotificationExecutorRing");
        this.shutdownExecutorServices(this.registryNotificationExecutorRing.listItems(), "registryNotificationExecutorRing");
    }

    private void shutdownExecutorServices(List<? extends ExecutorService> executorServices, String msg) {
        for (ExecutorService executorService : executorServices) {
            this.shutdownExecutorService(executorService, msg);
        }
    }

    private void shutdownExecutorService(ExecutorService executorService, String name) {
        try {
            executorService.shutdownNow();
        }
        catch (Exception e) {
            String msg = "shutdown executor service [" + name + "] failed: ";
            logger.warn(msg + e.getMessage(), e);
        }
    }

    @Override
    public void setExtensionAccessor(ExtensionAccessor extensionAccessor) {
        this.extensionAccessor = extensionAccessor;
    }

    @Override
    public void setApplicationModel(ApplicationModel applicationModel) {
        this.applicationModel = applicationModel;
    }

    private /* synthetic */ ExecutorService lambda$createExecutorIfAbsent$1(URL finalUrl, Integer k) {
        return this.createExecutor(finalUrl);
    }
}

