/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.model;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.config.ServiceConfigBase;
import org.apache.dubbo.rpc.model.ModuleModel;
import org.apache.dubbo.rpc.model.ProviderMethodModel;
import org.apache.dubbo.rpc.model.ServiceDescriptor;
import org.apache.dubbo.rpc.model.ServiceMetadata;
import org.apache.dubbo.rpc.model.ServiceModel;

public class ProviderModel
extends ServiceModel {
    private final List<RegisterStatedURL> urls;
    private final Map<String, List<ProviderMethodModel>> methods = new HashMap<String, List<ProviderMethodModel>>();

    public ProviderModel(String serviceKey, Object serviceInstance, ServiceDescriptor serviceModel, ServiceConfigBase<?> serviceConfig) {
        super(serviceInstance, serviceKey, serviceModel, serviceConfig);
        if (null == serviceInstance) {
            throw new IllegalArgumentException("Service[" + serviceKey + "]Target is NULL.");
        }
        this.urls = new ArrayList<RegisterStatedURL>(1);
    }

    public ProviderModel(String serviceKey, Object serviceInstance, ServiceDescriptor serviceModel, ServiceConfigBase<?> serviceConfig, ServiceMetadata serviceMetadata) {
        super(serviceInstance, serviceKey, serviceModel, serviceConfig, serviceMetadata);
        if (null == serviceInstance) {
            throw new IllegalArgumentException("Service[" + serviceKey + "]Target is NULL.");
        }
        this.initMethod(serviceModel.getServiceInterfaceClass());
        this.urls = new ArrayList<RegisterStatedURL>(1);
    }

    public ProviderModel(String serviceKey, Object serviceInstance, ServiceDescriptor serviceModel, ServiceConfigBase<?> serviceConfig, ModuleModel moduleModel, ServiceMetadata serviceMetadata) {
        super(serviceInstance, serviceKey, serviceModel, serviceConfig, moduleModel, serviceMetadata);
        if (null == serviceInstance) {
            throw new IllegalArgumentException("Service[" + serviceKey + "]Target is NULL.");
        }
        this.initMethod(serviceModel.getServiceInterfaceClass());
        this.urls = new ArrayList<RegisterStatedURL>(1);
    }

    public Object getServiceInstance() {
        return this.getProxyObject();
    }

    public List<RegisterStatedURL> getStatedUrl() {
        return this.urls;
    }

    public void addStatedUrl(RegisterStatedURL url) {
        this.urls.add(url);
    }

    public List<ProviderMethodModel> getAllMethodModels() {
        ArrayList<ProviderMethodModel> result = new ArrayList<ProviderMethodModel>();
        for (List<ProviderMethodModel> models : this.methods.values()) {
            result.addAll(models);
        }
        return result;
    }

    public ProviderMethodModel getMethodModel(String methodName, String[] argTypes) {
        List<ProviderMethodModel> methodModels = this.methods.get(methodName);
        if (methodModels != null) {
            for (ProviderMethodModel methodModel : methodModels) {
                if (!Arrays.equals(argTypes, methodModel.getMethodArgTypes())) continue;
                return methodModel;
            }
        }
        return null;
    }

    public List<ProviderMethodModel> getMethodModelList(String methodName) {
        List<ProviderMethodModel> resultList = this.methods.get(methodName);
        return resultList == null ? Collections.emptyList() : resultList;
    }

    private void initMethod(Class<?> serviceInterfaceClass) {
        Method[] methodsToExport;
        for (Method method : methodsToExport = serviceInterfaceClass.getMethods()) {
            method.setAccessible(true);
            List methodModels = this.methods.computeIfAbsent(method.getName(), k -> new ArrayList());
            methodModels.add(new ProviderMethodModel(method));
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ProviderModel that = (ProviderModel)o;
        return Objects.equals(this.urls, that.urls) && Objects.equals(this.methods, that.methods);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.urls, this.methods);
    }

    public static class RegisterStatedURL {
        private volatile URL registryUrl;
        private volatile URL providerUrl;
        private volatile boolean registered;

        public RegisterStatedURL(URL providerUrl, URL registryUrl, boolean registered) {
            this.providerUrl = providerUrl;
            this.registered = registered;
            this.registryUrl = registryUrl;
        }

        public URL getProviderUrl() {
            return this.providerUrl;
        }

        public void setProviderUrl(URL providerUrl) {
            this.providerUrl = providerUrl;
        }

        public boolean isRegistered() {
            return this.registered;
        }

        public void setRegistered(boolean registered) {
            this.registered = registered;
        }

        public URL getRegistryUrl() {
            return this.registryUrl;
        }

        public void setRegistryUrl(URL registryUrl) {
            this.registryUrl = registryUrl;
        }
    }
}

