/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.json.impl;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.lang.reflect.Type;
import java.util.List;
import org.apache.dubbo.common.json.impl.AbstractJSONImpl;
import org.apache.dubbo.common.utils.ClassUtils;

public class JacksonImpl
extends AbstractJSONImpl {
    private volatile Object jacksonCache = null;

    @Override
    public boolean isSupport() {
        try {
            Class<?> aClass = ClassUtils.forName("com.fasterxml.jackson.databind.json.JsonMapper");
            return aClass != null;
        }
        catch (Throwable t) {
            return false;
        }
    }

    @Override
    public <T> T toJavaObject(String json, Type type) {
        try {
            return (T)this.getJackson().readValue(json, this.getJackson().getTypeFactory().constructType(type));
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public <T> List<T> toJavaList(String json, Class<T> clazz) {
        try {
            return (List)this.getJackson().readValue(json, (JavaType)this.getJackson().getTypeFactory().constructCollectionType(List.class, clazz));
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public String toJson(Object obj) {
        try {
            return this.getJackson().writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JsonMapper getJackson() {
        if (this.jacksonCache == null || !(this.jacksonCache instanceof JsonMapper)) {
            JacksonImpl jacksonImpl = this;
            synchronized (jacksonImpl) {
                if (this.jacksonCache == null || !(this.jacksonCache instanceof JsonMapper)) {
                    this.jacksonCache = ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().configure(MapperFeature.PROPAGATE_TRANSIENT_MARKER, true)).serializationInclusion(JsonInclude.Include.NON_NULL)).addModule((Module)new JavaTimeModule())).build();
                }
            }
        }
        return (JsonMapper)this.jacksonCache;
    }
}

