/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.threadpool.manager;

import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.extension.ExtensionScope;
import org.apache.dubbo.common.extension.SPI;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.config.ApplicationConfig;
import org.apache.dubbo.rpc.executor.ExecutorSupport;
import org.apache.dubbo.rpc.model.ApplicationModel;

@SPI(value="default", scope=ExtensionScope.APPLICATION)
public interface ExecutorRepository {
    public ExecutorService createExecutorIfAbsent(URL var1);

    public ExecutorService getExecutor(URL var1);

    public void updateThreadpool(URL var1, ExecutorService var2);

    public ScheduledExecutorService getServiceExportExecutor();

    public void shutdownServiceExportExecutor();

    public ExecutorService getServiceReferExecutor();

    public void shutdownServiceReferExecutor();

    public void destroyAll();

    @Deprecated
    public ScheduledExecutorService nextScheduledExecutor();

    @Deprecated
    public ExecutorService nextExecutorExecutor();

    @Deprecated
    public ScheduledExecutorService getServiceDiscoveryAddressNotificationExecutor();

    @Deprecated
    public ScheduledExecutorService getMetadataRetryExecutor();

    @Deprecated
    public ScheduledExecutorService getRegistryNotificationExecutor();

    @Deprecated
    public ExecutorService getSharedExecutor();

    @Deprecated
    public ScheduledExecutorService getSharedScheduledExecutor();

    @Deprecated
    public ExecutorService getPoolRouterExecutor();

    @Deprecated
    public ScheduledExecutorService getConnectivityScheduledExecutor();

    @Deprecated
    public ScheduledExecutorService getCacheRefreshingScheduledExecutor();

    @Deprecated
    public ExecutorService getMappingRefreshingExecutor();

    public ExecutorSupport getExecutorSupport(URL var1);

    public static ExecutorRepository getInstance(ApplicationModel applicationModel) {
        ExtensionLoader<ExecutorRepository> extensionLoader = applicationModel.getExtensionLoader(ExecutorRepository.class);
        String mode = ExecutorRepository.getMode(applicationModel);
        return StringUtils.isNotEmpty(mode) ? extensionLoader.getExtension(mode) : extensionLoader.getDefaultExtension();
    }

    public static String getMode(ApplicationModel applicationModel) {
        Optional<ApplicationConfig> optional = applicationModel.getApplicationConfigManager().getApplication();
        return optional.map(ApplicationConfig::getExecutorManagementMode).orElse("default");
    }
}

