/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.utils;

import java.io.IOException;
import java.util.Arrays;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.dubbo.common.beanutil.JavaBeanSerializeUtil;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.ClassUtils;
import org.apache.dubbo.common.utils.ConcurrentHashSet;
import org.apache.dubbo.common.utils.IOUtils;
import org.apache.dubbo.common.utils.LFUCache;
import org.apache.dubbo.common.utils.StringUtils;

public class SerializeClassChecker {
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(SerializeClassChecker.class);
    private static volatile SerializeClassChecker INSTANCE = null;
    private final boolean OPEN_CHECK_CLASS;
    private final boolean BLOCK_ALL_CLASS_EXCEPT_ALLOW;
    private final Set<String> CLASS_DESERIALIZE_ALLOWED_SET = new ConcurrentHashSet<String>();
    private final Set<String> CLASS_DESERIALIZE_BLOCKED_SET = new ConcurrentHashSet<String>();
    private final Object CACHE = new Object();
    private final LFUCache<String, Object> CLASS_ALLOW_LFU_CACHE = new LFUCache();
    private final LFUCache<String, Object> CLASS_BLOCK_LFU_CACHE = new LFUCache();
    private final AtomicLong counter = new AtomicLong(0L);

    private SerializeClassChecker() {
        String openCheckClass = System.getProperty("dubbo.security.serialize.openCheckClass", "true");
        this.OPEN_CHECK_CLASS = Boolean.parseBoolean(openCheckClass);
        String blockAllClassExceptAllow = System.getProperty("dubbo.security.serialize.blockAllClassExceptAllow", "false");
        this.BLOCK_ALL_CLASS_EXCEPT_ALLOW = Boolean.parseBoolean(blockAllClassExceptAllow);
        try {
            ClassLoader classLoader = ClassUtils.getClassLoader(JavaBeanSerializeUtil.class);
            String[] lines = classLoader != null ? IOUtils.readLines(classLoader.getResourceAsStream("security/serialize.blockedlist")) : IOUtils.readLines(ClassLoader.getSystemResourceAsStream("security/serialize.blockedlist"));
            for (String line : lines) {
                if (StringUtils.isEmpty(line = line.trim()) || line.startsWith("#")) continue;
                this.CLASS_DESERIALIZE_BLOCKED_SET.add(line);
            }
        }
        catch (IOException e) {
            logger.error("0-22", "", "", "Failed to load blocked class list! Will ignore default blocked list.", e);
        }
        String allowedClassList = System.getProperty("dubbo.security.serialize.allowedClassList", "").trim().toLowerCase(Locale.ROOT);
        String blockedClassList = System.getProperty("dubbo.security.serialize.blockedClassList", "").trim().toLowerCase(Locale.ROOT);
        if (StringUtils.isNotEmpty(allowedClassList)) {
            String[] classStrings = allowedClassList.trim().split(",");
            this.CLASS_DESERIALIZE_ALLOWED_SET.addAll(Arrays.asList(classStrings));
        }
        if (StringUtils.isNotEmpty(blockedClassList)) {
            String[] classStrings = blockedClassList.trim().split(",");
            this.CLASS_DESERIALIZE_BLOCKED_SET.addAll(Arrays.asList(classStrings));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SerializeClassChecker getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<SerializeClassChecker> clazz = SerializeClassChecker.class;
        synchronized (SerializeClassChecker.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new SerializeClassChecker();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    @Deprecated
    protected static void clearInstance() {
        INSTANCE = null;
    }

    public void validateClass(String name) {
        this.validateClass(name, true);
    }

    public boolean validateClass(String name, boolean failOnError) {
        if (!this.OPEN_CHECK_CLASS) {
            return true;
        }
        if (this.CACHE == this.CLASS_ALLOW_LFU_CACHE.get(name = name.toLowerCase(Locale.ROOT))) {
            return true;
        }
        if (this.CACHE == this.CLASS_BLOCK_LFU_CACHE.get(name)) {
            if (failOnError) {
                this.error(name);
            }
            return false;
        }
        for (String allowedPrefix : this.CLASS_DESERIALIZE_ALLOWED_SET) {
            if (!name.startsWith(allowedPrefix)) continue;
            this.CLASS_ALLOW_LFU_CACHE.put(name, this.CACHE);
            return true;
        }
        for (String blockedPrefix : this.CLASS_DESERIALIZE_BLOCKED_SET) {
            if (!this.BLOCK_ALL_CLASS_EXCEPT_ALLOW && !name.startsWith(blockedPrefix)) continue;
            this.CLASS_BLOCK_LFU_CACHE.put(name, this.CACHE);
            if (failOnError) {
                this.error(name);
            }
            return false;
        }
        this.CLASS_ALLOW_LFU_CACHE.put(name, this.CACHE);
        return true;
    }

    private void error(String name) {
        String notice = "Trigger the safety barrier! Catch not allowed serialize class. Class name: " + name + " . This means currently maybe being attacking by others.If you are sure this is a mistake, please add this class name to `" + "dubbo.security.serialize.allowedClassList" + "` as a system environment property.";
        if (this.counter.incrementAndGet() % 1000L == 0L || this.counter.get() < 100L) {
            logger.error("4-4", "", "", notice);
        }
        throw new IllegalArgumentException(notice);
    }
}

