/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.utils;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.AllowClassNotifyListener;
import org.apache.dubbo.common.utils.ClassLoaderResourceLoader;
import org.apache.dubbo.common.utils.ConcurrentHashSet;
import org.apache.dubbo.common.utils.IOUtils;
import org.apache.dubbo.common.utils.SerializeCheckStatus;
import org.apache.dubbo.common.utils.SerializeClassChecker;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.rpc.model.FrameworkModel;

public class SerializeSecurityManager {
    private final Set<String> allowedPrefix = new LinkedHashSet<String>();
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(SerializeSecurityManager.class);
    private final SerializeClassChecker checker = SerializeClassChecker.getInstance();
    private final Set<AllowClassNotifyListener> listeners = new ConcurrentHashSet<AllowClassNotifyListener>();
    private volatile SerializeCheckStatus checkStatus = AllowClassNotifyListener.DEFAULT_STATUS;

    public SerializeSecurityManager(FrameworkModel frameworkModel) {
        try {
            Set<ClassLoader> classLoaders = frameworkModel.getClassLoaders();
            List urls = ClassLoaderResourceLoader.loadResources("security/serialize.allowlist", classLoaders).values().stream().flatMap(Collection::stream).collect(Collectors.toList());
            for (URL u : urls) {
                try {
                    String[] lines;
                    logger.info("Read serialize allow list from " + u);
                    for (String line : lines = IOUtils.readLines(u.openStream())) {
                        if (StringUtils.isEmpty(line = line.trim()) || line.startsWith("#")) continue;
                        this.allowedPrefix.add(line);
                    }
                }
                catch (IOException e) {
                    logger.error("0-22", "", "", "Failed to load allow class list! Will ignore allow lis from " + u, e);
                }
            }
            this.checkStatus = SerializeCheckStatus.valueOf(System.getProperty("dubbo.application.serialize-check-status", AllowClassNotifyListener.DEFAULT_STATUS.name()));
            logger.info("Serialize check level: " + this.checkStatus.name());
        }
        catch (InterruptedException e) {
            logger.error("99-1", "", "", "Failed to load allow class list! Will ignore allow list from configuration.", e);
            Thread.currentThread().interrupt();
        }
    }

    public void registerInterface(Class<?> clazz) {
        Method[] methodsToExport;
        HashSet markedClass = new HashSet();
        markedClass.add(clazz);
        this.addToAllow(clazz.getName());
        for (Method method : methodsToExport = clazz.getMethods()) {
            Type[] typeArray;
            Class<?>[] exceptionTypes;
            Type[] genericParameterTypes;
            Class<?>[] parameterTypes;
            for (Class<?> parameterType : parameterTypes = method.getParameterTypes()) {
                this.checkClass(markedClass, parameterType);
            }
            for (Type type : genericParameterTypes = method.getGenericParameterTypes()) {
                this.checkType(markedClass, type);
            }
            Class<?> returnType = method.getReturnType();
            this.checkClass(markedClass, returnType);
            Type genericReturnType = method.getGenericReturnType();
            this.checkType(markedClass, genericReturnType);
            for (Class<?> exceptionType : exceptionTypes = method.getExceptionTypes()) {
                this.checkClass(markedClass, exceptionType);
            }
            for (Type genericExceptionType : typeArray = method.getGenericExceptionTypes()) {
                this.checkType(markedClass, genericExceptionType);
            }
        }
    }

    private void checkType(Set<Class<?>> markedClass, Type type) {
        block5: {
            block8: {
                block7: {
                    block6: {
                        block4: {
                            if (!(type instanceof Class)) break block4;
                            this.checkClass(markedClass, (Class)type);
                            break block5;
                        }
                        if (!(type instanceof ParameterizedType)) break block6;
                        ParameterizedType parameterizedType = (ParameterizedType)type;
                        this.checkClass(markedClass, (Class)parameterizedType.getRawType());
                        for (Type actualTypeArgument : parameterizedType.getActualTypeArguments()) {
                            this.checkType(markedClass, actualTypeArgument);
                        }
                        break block5;
                    }
                    if (!(type instanceof GenericArrayType)) break block7;
                    GenericArrayType genericArrayType = (GenericArrayType)type;
                    this.checkType(markedClass, genericArrayType.getGenericComponentType());
                    break block5;
                }
                if (!(type instanceof TypeVariable)) break block8;
                TypeVariable typeVariable = (TypeVariable)type;
                for (Type bound : typeVariable.getBounds()) {
                    this.checkType(markedClass, bound);
                }
                break block5;
            }
            if (!(type instanceof WildcardType)) break block5;
            WildcardType wildcardType = (WildcardType)type;
            for (Type bound : wildcardType.getUpperBounds()) {
                this.checkType(markedClass, bound);
            }
            for (Type bound : wildcardType.getLowerBounds()) {
                this.checkType(markedClass, bound);
            }
        }
    }

    private void checkClass(Set<Class<?>> markedClass, Class<?> clazz) {
        Field[] fields;
        Class<?>[] interfaces;
        if (markedClass.contains(clazz)) {
            return;
        }
        markedClass.add(clazz);
        this.addToAllow(clazz.getName());
        for (Class<?> interfaceClass : interfaces = clazz.getInterfaces()) {
            this.checkClass(markedClass, interfaceClass);
        }
        Class<?> superclass = clazz.getSuperclass();
        if (superclass != null) {
            this.checkClass(markedClass, superclass);
        }
        for (Field field : fields = clazz.getDeclaredFields()) {
            if (Modifier.isTransient(field.getModifiers())) continue;
            Class<?> fieldClass = field.getType();
            this.checkClass(markedClass, fieldClass);
            this.checkType(markedClass, field.getGenericType());
        }
    }

    protected void addToAllow(String className) {
        if (!this.checker.validateClass(className, false)) {
            return;
        }
        if (className.startsWith("java.") || className.startsWith("javax.") || className.startsWith("com.sun.") || className.startsWith("sun.") || className.startsWith("jdk.")) {
            boolean modified = this.allowedPrefix.add(className);
            if (modified) {
                this.notifyListeners();
            }
            return;
        }
        String[] subs = className.split("\\.");
        boolean modified = subs.length > 3 ? this.allowedPrefix.add(subs[0] + "." + subs[1] + "." + subs[2]) : this.allowedPrefix.add(className);
        if (modified) {
            this.notifyListeners();
        }
    }

    public void registerListener(AllowClassNotifyListener listener) {
        this.listeners.add(listener);
        listener.notify(this.checkStatus, this.allowedPrefix);
    }

    private void notifyListeners() {
        for (AllowClassNotifyListener listener : this.listeners) {
            listener.notify(this.checkStatus, this.allowedPrefix);
        }
    }

    protected Set<String> getAllowedPrefix() {
        return this.allowedPrefix;
    }
}

