/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executor;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.config.AbstractInterfaceConfig;
import org.apache.dubbo.config.ProtocolConfig;
import org.apache.dubbo.config.support.Parameter;
import org.apache.dubbo.rpc.model.ModuleModel;

public abstract class AbstractServiceConfig
extends AbstractInterfaceConfig {
    private static final long serialVersionUID = -9026290350363878309L;
    protected String version;
    protected String group;
    protected Boolean deprecated;
    protected Integer delay;
    protected Boolean export;
    protected Integer weight;
    protected String document;
    protected Boolean dynamic;
    protected String token;
    protected String accesslog;
    protected List<ProtocolConfig> protocols;
    protected String protocolIds;
    private Integer executes;
    private Boolean register;
    private Integer warmup;
    private String serialization;
    private String preferSerialization;
    @Deprecated
    private Boolean exportAsync;
    private Executor executor;

    public AbstractServiceConfig() {
    }

    public AbstractServiceConfig(ModuleModel moduleModel) {
        super(moduleModel);
    }

    @Override
    protected void checkDefault() {
        super.checkDefault();
        if (this.deprecated == null) {
            this.deprecated = false;
        }
        if (this.dynamic == null) {
            this.dynamic = true;
        }
        if (StringUtils.isBlank(this.preferSerialization)) {
            this.preferSerialization = this.serialization;
        }
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    @Override
    public void setGroup(String group) {
        this.group = group;
    }

    public Integer getDelay() {
        return this.delay;
    }

    public void setDelay(Integer delay) {
        this.delay = delay;
    }

    public Boolean getExport() {
        return this.export;
    }

    public void setExport(Boolean export) {
        this.export = export;
    }

    public Integer getWeight() {
        return this.weight;
    }

    public void setWeight(Integer weight) {
        this.weight = weight;
    }

    @Parameter(escaped=true)
    public String getDocument() {
        return this.document;
    }

    public void setDocument(String document) {
        this.document = document;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(Boolean token) {
        if (token == null) {
            this.setToken((String)null);
        } else {
            this.setToken(String.valueOf(token));
        }
    }

    public void setToken(String token) {
        this.token = token;
    }

    public Boolean isDeprecated() {
        return this.deprecated;
    }

    public void setDeprecated(Boolean deprecated) {
        this.deprecated = deprecated;
    }

    public Boolean isDynamic() {
        return this.dynamic;
    }

    public void setDynamic(Boolean dynamic) {
        this.dynamic = dynamic;
    }

    public List<ProtocolConfig> getProtocols() {
        return this.protocols;
    }

    public void setProtocols(List<? extends ProtocolConfig> protocols) {
        this.protocols = protocols;
    }

    public ProtocolConfig getProtocol() {
        return CollectionUtils.isEmpty(this.protocols) ? null : this.protocols.get(0);
    }

    public void setProtocol(ProtocolConfig protocol) {
        this.setProtocols(new ArrayList<ProtocolConfig>(Arrays.asList(protocol)));
    }

    @Parameter(excluded=true)
    public String getProtocolIds() {
        return this.protocolIds;
    }

    public void setProtocolIds(String protocolIds) {
        this.protocolIds = protocolIds;
    }

    public String getAccesslog() {
        return this.accesslog;
    }

    public void setAccesslog(Boolean accesslog) {
        if (accesslog == null) {
            this.setAccesslog((String)null);
        } else {
            this.setAccesslog(String.valueOf(accesslog));
        }
    }

    public void setAccesslog(String accesslog) {
        this.accesslog = accesslog;
    }

    public Integer getExecutes() {
        return this.executes;
    }

    public void setExecutes(Integer executes) {
        this.executes = executes;
    }

    @Override
    @Parameter(key="service.filter", append=true)
    public String getFilter() {
        return super.getFilter();
    }

    @Override
    @Parameter(key="exporter.listener", append=true)
    public String getListener() {
        return this.listener;
    }

    @Override
    public void setListener(String listener) {
        this.listener = listener;
    }

    public Boolean isRegister() {
        return this.register;
    }

    public void setRegister(Boolean register) {
        this.register = register;
    }

    public Integer getWarmup() {
        return this.warmup;
    }

    public void setWarmup(Integer warmup) {
        this.warmup = warmup;
    }

    public String getSerialization() {
        return this.serialization;
    }

    public void setSerialization(String serialization) {
        this.serialization = serialization;
    }

    public String getPreferSerialization() {
        return this.preferSerialization;
    }

    public void setPreferSerialization(String preferSerialization) {
        this.preferSerialization = preferSerialization;
    }

    @Deprecated
    @Parameter(key="export-async")
    public Boolean getExportAsync() {
        return this.exportAsync;
    }

    @Deprecated
    public void setExportAsync(Boolean exportAsync) {
        this.exportAsync = exportAsync;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    @Parameter(key="service-executor")
    public Executor getExecutor() {
        return this.executor;
    }
}

