/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.dubbo.common.BaseServiceMetadata;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.utils.ConcurrentHashMapUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.rpc.model.ConsumerModel;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.model.ProviderModel;

public class FrameworkServiceRepository {
    private FrameworkModel frameworkModel;
    private ConcurrentMap<String, ProviderModel> providers = new ConcurrentHashMap<String, ProviderModel>();
    private ConcurrentMap<String, List<ProviderModel>> providersWithoutGroup = new ConcurrentHashMap<String, List<ProviderModel>>();
    private ConcurrentMap<String, List<URL>> providerUrlsWithoutGroup = new ConcurrentHashMap<String, List<URL>>();

    public FrameworkServiceRepository(FrameworkModel frameworkModel) {
        this.frameworkModel = frameworkModel;
    }

    public void registerProvider(ProviderModel providerModel) {
        String key = providerModel.getServiceKey();
        ProviderModel previous = this.providers.putIfAbsent(key, providerModel);
        if (previous == null || previous != providerModel) {
            // empty if block
        }
        String keyWithoutGroup = FrameworkServiceRepository.keyWithoutGroup(key);
        ConcurrentHashMapUtils.computeIfAbsent(this.providersWithoutGroup, keyWithoutGroup, k -> new CopyOnWriteArrayList()).add(providerModel);
    }

    public void unregisterProvider(ProviderModel providerModel) {
        this.providers.remove(providerModel.getServiceKey());
        String keyWithoutGroup = FrameworkServiceRepository.keyWithoutGroup(providerModel.getServiceKey());
        this.providersWithoutGroup.remove(keyWithoutGroup);
        this.providerUrlsWithoutGroup.remove(keyWithoutGroup);
    }

    public ProviderModel lookupExportedServiceWithoutGroup(String key) {
        if (this.providersWithoutGroup.containsKey(key)) {
            List providerModels = (List)this.providersWithoutGroup.get(key);
            return providerModels.size() > 0 ? (ProviderModel)providerModels.get(0) : null;
        }
        return null;
    }

    public List<ProviderModel> lookupExportedServicesWithoutGroup(String key) {
        return (List)this.providersWithoutGroup.get(key);
    }

    public void registerProviderUrl(URL url) {
        ConcurrentHashMapUtils.computeIfAbsent(this.providerUrlsWithoutGroup, FrameworkServiceRepository.keyWithoutGroup(url.getServiceKey()), k -> new CopyOnWriteArrayList()).add(url);
    }

    public ProviderModel lookupExportedService(String serviceKey) {
        return (ProviderModel)this.providers.get(serviceKey);
    }

    public List<URL> lookupRegisteredProviderUrlsWithoutGroup(String key) {
        return (List)this.providerUrlsWithoutGroup.get(key);
    }

    public List<ProviderModel> allProviderModels() {
        return Collections.unmodifiableList(new ArrayList(this.providers.values()));
    }

    public List<ConsumerModel> allConsumerModels() {
        LinkedList consumerModels = new LinkedList();
        this.frameworkModel.getApplicationModels().forEach(applicationModel -> consumerModels.addAll(applicationModel.getApplicationServiceRepository().allConsumerModels()));
        return Collections.unmodifiableList(consumerModels);
    }

    private static String keyWithoutGroup(String serviceKey) {
        String interfaceName = BaseServiceMetadata.interfaceFromServiceKey(serviceKey);
        String version = BaseServiceMetadata.versionFromServiceKey(serviceKey);
        if (StringUtils.isEmpty(version)) {
            return interfaceName;
        }
        return interfaceName + ":" + version;
    }
}

