/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.utils;

import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.MethodUtils;
import org.apache.dubbo.common.utils.StringUtils;

public enum JRE {
    JAVA_8,
    JAVA_9,
    JAVA_10,
    JAVA_11,
    JAVA_12,
    JAVA_13,
    JAVA_14,
    JAVA_15,
    JAVA_16,
    JAVA_17,
    JAVA_18,
    JAVA_19,
    JAVA_20,
    JAVA_21,
    JAVA_22,
    JAVA_23,
    OTHER;

    private static final ErrorTypeAwareLogger logger;
    private static final JRE VERSION;

    public static JRE currentVersion() {
        return VERSION;
    }

    public boolean isCurrentVersion() {
        return this == VERSION;
    }

    private static JRE getJre() {
        String version = System.getProperty("java.version");
        boolean isBlank = StringUtils.isBlank(version);
        if (isBlank) {
            logger.debug("java.version is blank");
        }
        if (!isBlank && version.startsWith("1.8")) {
            return JAVA_8;
        }
        try {
            Object javaRunTimeVersion = MethodUtils.invokeMethod(Runtime.getRuntime(), "version", new Object[0]);
            int majorVersion = (Integer)MethodUtils.invokeMethod(javaRunTimeVersion, "major", new Object[0]);
            switch (majorVersion) {
                case 9: {
                    return JAVA_9;
                }
                case 10: {
                    return JAVA_10;
                }
                case 11: {
                    return JAVA_11;
                }
                case 12: {
                    return JAVA_12;
                }
                case 13: {
                    return JAVA_13;
                }
                case 14: {
                    return JAVA_14;
                }
                case 15: {
                    return JAVA_15;
                }
                case 16: {
                    return JAVA_16;
                }
                case 17: {
                    return JAVA_17;
                }
                case 18: {
                    return JAVA_18;
                }
                case 19: {
                    return JAVA_19;
                }
                case 20: {
                    return JAVA_20;
                }
                case 21: {
                    return JAVA_21;
                }
                case 22: {
                    return JAVA_22;
                }
            }
            return OTHER;
        }
        catch (Exception e) {
            logger.debug("Can't determine current JRE version (maybe java.version is null), assuming that JRE version is 8.", e);
            return JAVA_8;
        }
    }

    static {
        logger = LoggerFactory.getErrorTypeAwareLogger(JRE.class);
        VERSION = JRE.getJre();
    }
}

