/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.model;

import org.apache.dubbo.common.extension.ExtensionPostProcessor;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.model.ModuleModel;
import org.apache.dubbo.rpc.model.ScopeModel;
import org.apache.dubbo.rpc.model.ScopeModelAccessor;
import org.apache.dubbo.rpc.model.ScopeModelAware;

public class ScopeModelAwareExtensionProcessor
implements ExtensionPostProcessor,
ScopeModelAccessor {
    private ScopeModel scopeModel;
    private FrameworkModel frameworkModel;
    private ApplicationModel applicationModel;
    private ModuleModel moduleModel;

    public ScopeModelAwareExtensionProcessor(ScopeModel scopeModel) {
        this.scopeModel = scopeModel;
        this.initialize();
    }

    private void initialize() {
        if (this.scopeModel instanceof FrameworkModel) {
            this.frameworkModel = (FrameworkModel)this.scopeModel;
        } else if (this.scopeModel instanceof ApplicationModel) {
            this.applicationModel = (ApplicationModel)this.scopeModel;
            this.frameworkModel = this.applicationModel.getFrameworkModel();
        } else if (this.scopeModel instanceof ModuleModel) {
            this.moduleModel = (ModuleModel)this.scopeModel;
            this.applicationModel = this.moduleModel.getApplicationModel();
            this.frameworkModel = this.applicationModel.getFrameworkModel();
        }
    }

    @Override
    public Object postProcessAfterInitialization(Object instance, String name) throws Exception {
        if (instance instanceof ScopeModelAware) {
            ScopeModelAware modelAware = (ScopeModelAware)instance;
            modelAware.setScopeModel(this.scopeModel);
            if (this.moduleModel != null) {
                modelAware.setModuleModel(this.moduleModel);
            }
            if (this.applicationModel != null) {
                modelAware.setApplicationModel(this.applicationModel);
            }
            if (this.frameworkModel != null) {
                modelAware.setFrameworkModel(this.frameworkModel);
            }
        }
        return instance;
    }

    @Override
    public ScopeModel getScopeModel() {
        return this.scopeModel;
    }

    @Override
    public FrameworkModel getFrameworkModel() {
        return this.frameworkModel;
    }

    @Override
    public ApplicationModel getApplicationModel() {
        return this.applicationModel;
    }

    @Override
    public ModuleModel getModuleModel() {
        return this.moduleModel;
    }
}

