/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metadata.definition.builder;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.apache.dubbo.metadata.definition.TypeDefinitionBuilder;
import org.apache.dubbo.metadata.definition.builder.TypeBuilder;
import org.apache.dubbo.metadata.definition.model.TypeDefinition;
import org.apache.dubbo.metadata.definition.util.ClassUtils;

public class CollectionTypeBuilder
implements TypeBuilder {
    @Override
    public boolean accept(Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        return Collection.class.isAssignableFrom(clazz);
    }

    @Override
    public TypeDefinition build(Type type, Class<?> clazz, Map<String, TypeDefinition> typeCache) {
        if (!(type instanceof ParameterizedType)) {
            return new TypeDefinition(clazz.getCanonicalName());
        }
        ParameterizedType parameterizedType = (ParameterizedType)type;
        Object[] actualTypeArgs = parameterizedType.getActualTypeArguments();
        if (actualTypeArgs == null || actualTypeArgs.length != 1) {
            throw new IllegalArgumentException(MessageFormat.format("[ServiceDefinitionBuilder] Collection type [{0}] with unexpected amount of arguments [{1}]." + Arrays.toString(actualTypeArgs), type, actualTypeArgs));
        }
        String colType = ClassUtils.getCanonicalNameForParameterizedType(parameterizedType);
        TypeDefinition td = typeCache.get(colType);
        if (td != null) {
            return td;
        }
        td = new TypeDefinition(colType);
        typeCache.put(colType, td);
        Object actualType = actualTypeArgs[0];
        TypeDefinition itemTd = null;
        if (actualType instanceof ParameterizedType) {
            Class rawType = (Class)((ParameterizedType)actualType).getRawType();
            itemTd = TypeDefinitionBuilder.build((Type)actualType, rawType, typeCache);
        } else if (actualType instanceof Class) {
            Class actualClass = (Class)actualType;
            itemTd = TypeDefinitionBuilder.build(null, actualClass, typeCache);
        }
        if (itemTd != null) {
            td.getItems().add(itemTd.getType());
        }
        return td;
    }
}

