/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.json.impl;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import org.apache.dubbo.common.json.impl.AbstractJsonUtilImpl;

public class GsonImpl
extends AbstractJsonUtilImpl {
    private volatile Object gsonCache = null;

    @Override
    public <T> T toJavaObject(String json, Type type) {
        return (T)this.getGson().fromJson(json, type);
    }

    @Override
    public <T> List<T> toJavaList(String json, Class<T> clazz) {
        return (List)this.getGson().fromJson(json, TypeToken.getParameterized(List.class, (Type[])new Type[]{clazz}).getType());
    }

    @Override
    public String toJson(Object obj) {
        return this.getGson().toJson(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Gson getGson() {
        if (this.gsonCache == null || !(this.gsonCache instanceof Gson)) {
            GsonImpl gsonImpl = this;
            synchronized (gsonImpl) {
                if (this.gsonCache == null || !(this.gsonCache instanceof Gson)) {
                    this.gsonCache = new Gson();
                }
            }
        }
        return (Gson)this.gsonCache;
    }
}

