/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.compact;

import java.lang.annotation.Annotation;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.common.utils.SystemPropertyConfigUtils;

public class Dubbo2CompactUtils {
    private static volatile boolean enabled = true;
    private static final Class<? extends Annotation> REFERENCE_CLASS;
    private static final Class<? extends Annotation> SERVICE_CLASS;
    private static final Class<?> ECHO_SERVICE_CLASS;
    private static final Class<?> GENERIC_SERVICE_CLASS;

    private static void initEnabled() {
        try {
            String fromProp = SystemPropertyConfigUtils.getSystemProperty("dubbo.compact.enable");
            if (StringUtils.isNotEmpty(fromProp)) {
                enabled = Boolean.parseBoolean(fromProp);
                return;
            }
            String fromEnv = System.getenv("dubbo.compact.enable");
            if (StringUtils.isNotEmpty(fromEnv)) {
                enabled = Boolean.parseBoolean(fromEnv);
                return;
            }
            fromEnv = System.getenv(StringUtils.toOSStyleKey("dubbo.compact.enable"));
            enabled = !StringUtils.isNotEmpty(fromEnv) || Boolean.parseBoolean(fromEnv);
        }
        catch (Throwable t) {
            enabled = true;
        }
    }

    public static boolean isEnabled() {
        return enabled;
    }

    public static void setEnabled(boolean enabled) {
        Dubbo2CompactUtils.enabled = enabled;
    }

    private static Class<?> loadClass(String name) {
        try {
            return Class.forName(name);
        }
        catch (Throwable e) {
            return null;
        }
    }

    private static Class<? extends Annotation> loadAnnotation(String name) {
        try {
            Class<?> clazz = Class.forName(name);
            if (clazz.isAnnotation()) {
                return clazz;
            }
            return null;
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static boolean isReferenceClassLoaded() {
        return REFERENCE_CLASS != null;
    }

    public static Class<? extends Annotation> getReferenceClass() {
        return REFERENCE_CLASS;
    }

    public static boolean isServiceClassLoaded() {
        return SERVICE_CLASS != null;
    }

    public static Class<? extends Annotation> getServiceClass() {
        return SERVICE_CLASS;
    }

    public static boolean isEchoServiceClassLoaded() {
        return ECHO_SERVICE_CLASS != null;
    }

    public static Class<?> getEchoServiceClass() {
        return ECHO_SERVICE_CLASS;
    }

    public static boolean isGenericServiceClassLoaded() {
        return GENERIC_SERVICE_CLASS != null;
    }

    public static Class<?> getGenericServiceClass() {
        return GENERIC_SERVICE_CLASS;
    }

    static {
        Dubbo2CompactUtils.initEnabled();
        REFERENCE_CLASS = Dubbo2CompactUtils.loadAnnotation("com.alibaba.dubbo.config.annotation.Reference");
        SERVICE_CLASS = Dubbo2CompactUtils.loadAnnotation("com.alibaba.dubbo.config.annotation.Service");
        ECHO_SERVICE_CLASS = Dubbo2CompactUtils.loadClass("com.alibaba.dubbo.rpc.service.EchoService");
        GENERIC_SERVICE_CLASS = Dubbo2CompactUtils.loadClass("com.alibaba.dubbo.rpc.service.GenericService");
    }
}

