/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.json.impl;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.json.impl.AbstractJsonUtilImpl;

@Activate(order=400, onClass={"com.fasterxml.jackson.databind.json.JsonMapper"})
public class JacksonImpl
extends AbstractJsonUtilImpl {
    private volatile JsonMapper mapper;
    private final List<Module> customModules = new ArrayList<Module>();

    @Override
    public String getName() {
        return "jackson";
    }

    @Override
    public boolean isJson(String json) {
        try {
            JsonNode node = this.getMapper().readTree(json);
            return node.isObject() || node.isArray();
        }
        catch (JsonProcessingException e) {
            return false;
        }
    }

    @Override
    public <T> T toJavaObject(String json, Type type) {
        try {
            JsonMapper mapper = this.getMapper();
            return (T)mapper.readValue(json, mapper.getTypeFactory().constructType(type));
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public <T> List<T> toJavaList(String json, Class<T> clazz) {
        try {
            JsonMapper mapper = this.getMapper();
            return (List)mapper.readValue(json, (JavaType)mapper.getTypeFactory().constructCollectionType(List.class, clazz));
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public String toJson(Object obj) {
        try {
            return this.getMapper().writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public String toPrettyJson(Object obj) {
        try {
            return this.getMapper().writerWithDefaultPrettyPrinter().writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public Object convertObject(Object obj, Type type) {
        JsonMapper mapper = this.getMapper();
        return mapper.convertValue(obj, mapper.constructType(type));
    }

    @Override
    public Object convertObject(Object obj, Class<?> clazz) {
        return this.getMapper().convertValue(obj, clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JsonMapper getMapper() {
        JsonMapper mapper = this.mapper;
        if (mapper == null) {
            JacksonImpl jacksonImpl = this;
            synchronized (jacksonImpl) {
                mapper = this.mapper;
                if (mapper == null) {
                    this.mapper = mapper = (JsonMapper)this.createBuilder().build();
                }
            }
        }
        return mapper;
    }

    protected JsonMapper.Builder createBuilder() {
        JsonMapper.Builder builder = (JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().configure(MapperFeature.PROPAGATE_TRANSIENT_MARKER, true)).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false)).serializationInclusion(JsonInclude.Include.NON_NULL)).addModule((Module)new JavaTimeModule());
        for (Module module : this.customModules) {
            builder.addModule(module);
        }
        return builder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addModule(Module module) {
        JacksonImpl jacksonImpl = this;
        synchronized (jacksonImpl) {
            this.customModules.add(module);
            this.mapper = null;
        }
    }
}

