/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.logger.log4j;

import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.support.FailsafeLogger;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MessageFormatter;

public class Log4jLogger
implements Logger {
    private static final String FQCN = FailsafeLogger.class.getName();
    private final org.apache.log4j.Logger logger;

    public Log4jLogger(org.apache.log4j.Logger logger) {
        this.logger = logger;
    }

    @Override
    public void trace(String msg) {
        this.logger.log(FQCN, (Priority)Level.TRACE, (Object)msg, null);
    }

    @Override
    public void trace(String msg, Object ... arguments) {
        FormattingTuple ft = MessageFormatter.arrayFormat((String)msg, (Object[])arguments);
        this.logger.log(FQCN, (Priority)Level.TRACE, (Object)ft.getMessage(), ft.getThrowable());
    }

    @Override
    public void trace(Throwable e) {
        this.logger.log(FQCN, (Priority)Level.TRACE, (Object)(e == null ? null : e.getMessage()), e);
    }

    @Override
    public void trace(String msg, Throwable e) {
        this.logger.log(FQCN, (Priority)Level.TRACE, (Object)msg, e);
    }

    @Override
    public void debug(String msg) {
        this.logger.log(FQCN, (Priority)Level.DEBUG, (Object)msg, null);
    }

    @Override
    public void debug(String msg, Object ... arguments) {
        FormattingTuple ft = MessageFormatter.arrayFormat((String)msg, (Object[])arguments);
        this.logger.log(FQCN, (Priority)Level.DEBUG, (Object)ft.getMessage(), ft.getThrowable());
    }

    @Override
    public void debug(Throwable e) {
        this.logger.log(FQCN, (Priority)Level.DEBUG, (Object)(e == null ? null : e.getMessage()), e);
    }

    @Override
    public void debug(String msg, Throwable e) {
        this.logger.log(FQCN, (Priority)Level.DEBUG, (Object)msg, e);
    }

    @Override
    public void info(String msg) {
        this.logger.log(FQCN, (Priority)Level.INFO, (Object)msg, null);
    }

    @Override
    public void info(String msg, Object ... arguments) {
        FormattingTuple ft = MessageFormatter.arrayFormat((String)msg, (Object[])arguments);
        this.logger.log(FQCN, (Priority)Level.INFO, (Object)ft.getMessage(), ft.getThrowable());
    }

    @Override
    public void info(Throwable e) {
        this.logger.log(FQCN, (Priority)Level.INFO, (Object)(e == null ? null : e.getMessage()), e);
    }

    @Override
    public void info(String msg, Throwable e) {
        this.logger.log(FQCN, (Priority)Level.INFO, (Object)msg, e);
    }

    @Override
    public void warn(String msg) {
        this.logger.log(FQCN, (Priority)Level.WARN, (Object)msg, null);
    }

    @Override
    public void warn(String msg, Object ... arguments) {
        FormattingTuple ft = MessageFormatter.arrayFormat((String)msg, (Object[])arguments);
        this.logger.log(FQCN, (Priority)Level.WARN, (Object)ft.getMessage(), ft.getThrowable());
    }

    @Override
    public void warn(Throwable e) {
        this.logger.log(FQCN, (Priority)Level.WARN, (Object)(e == null ? null : e.getMessage()), e);
    }

    @Override
    public void warn(String msg, Throwable e) {
        this.logger.log(FQCN, (Priority)Level.WARN, (Object)msg, e);
    }

    @Override
    public void error(String msg) {
        this.logger.log(FQCN, (Priority)Level.ERROR, (Object)msg, null);
    }

    @Override
    public void error(String msg, Object ... arguments) {
        FormattingTuple ft = MessageFormatter.arrayFormat((String)msg, (Object[])arguments);
        this.logger.log(FQCN, (Priority)Level.ERROR, (Object)ft.getMessage(), ft.getThrowable());
    }

    @Override
    public void error(Throwable e) {
        this.logger.log(FQCN, (Priority)Level.ERROR, (Object)(e == null ? null : e.getMessage()), e);
    }

    @Override
    public void error(String msg, Throwable e) {
        this.logger.log(FQCN, (Priority)Level.ERROR, (Object)msg, e);
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isEnabledFor((Priority)Level.WARN);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.logger.isEnabledFor((Priority)Level.ERROR);
    }
}

