/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.utils;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.ParameterNameReader;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.rpc.model.FrameworkModel;

public final class DefaultParameterNameReader
implements ParameterNameReader {
    private final Map<Object, Optional<String[]>> cache = CollectionUtils.newConcurrentHashMap();
    private final List<ParameterNameReader> readers;

    public DefaultParameterNameReader(FrameworkModel frameworkModel) {
        this.readers = frameworkModel.getActivateExtensions(ParameterNameReader.class);
    }

    @Override
    public String[] readParameterNames(Method method) {
        return this.cache.computeIfAbsent(method, k -> {
            String[] names;
            block1: {
                ParameterNameReader reader;
                names = DefaultParameterNameReader.readByReflection(method.getParameters());
                if (names != null) break block1;
                Iterator<ParameterNameReader> iterator = this.readers.iterator();
                while (iterator.hasNext() && (names = (reader = iterator.next()).readParameterNames(method)) == null) {
                }
            }
            return Optional.ofNullable(names);
        }).orElse(null);
    }

    @Override
    public String[] readParameterNames(Constructor<?> ctor) {
        return this.cache.computeIfAbsent(ctor, k -> {
            String[] names;
            block1: {
                ParameterNameReader reader;
                names = DefaultParameterNameReader.readByReflection(ctor.getParameters());
                if (names != null) break block1;
                Iterator<ParameterNameReader> iterator = this.readers.iterator();
                while (iterator.hasNext() && (names = (reader = iterator.next()).readParameterNames(ctor)) == null) {
                }
            }
            return Optional.ofNullable(names);
        }).orElse(null);
    }

    private static String[] readByReflection(Parameter[] parameters) {
        int len = parameters.length;
        if (len == 0) {
            return StringUtils.EMPTY_STRING_ARRAY;
        }
        String[] names = new String[len];
        for (int i = 0; i < len; ++i) {
            Parameter param = parameters[i];
            if (!param.isNamePresent()) {
                return null;
            }
            names[i] = param.getName();
        }
        return names;
    }
}

