/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.utils;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Map;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtBehavior;
import javassist.CtConstructor;
import javassist.CtMethod;
import javassist.LoaderClassPath;
import javassist.bytecode.CodeAttribute;
import javassist.bytecode.Descriptor;
import javassist.bytecode.LocalVariableAttribute;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.ClassUtils;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.ParameterNameReader;
import org.apache.dubbo.common.utils.StringUtils;

@Activate(order=100, onClass={"javassist.ClassPool"})
public class JavassistParameterNameReader
implements ParameterNameReader {
    private static final ErrorTypeAwareLogger LOG = LoggerFactory.getErrorTypeAwareLogger(JavassistParameterNameReader.class);
    private final Map<Integer, ClassPool> classPoolMap = CollectionUtils.newConcurrentHashMap();

    @Override
    public String[] readParameterNames(Method method) {
        try {
            Class<?>[] paramTypes = method.getParameterTypes();
            if (paramTypes.length == 0) {
                return StringUtils.EMPTY_STRING_ARRAY;
            }
            String descriptor = JavassistParameterNameReader.getDescriptor(paramTypes, method.getReturnType());
            Class<?> clazz = method.getDeclaringClass();
            CtMethod ctMethod = this.getClassPool(clazz).get(clazz.getName()).getMethod(method.getName(), descriptor);
            return JavassistParameterNameReader.read((CtBehavior)ctMethod, Modifier.isStatic(method.getModifiers()) ? 0 : 1, paramTypes.length);
        }
        catch (Throwable t) {
            LOG.warn("99-0", "", "", "Read parameter names error", t);
            return null;
        }
    }

    @Override
    public String[] readParameterNames(Constructor<?> ctor) {
        try {
            Class<?>[] paramTypes = ctor.getParameterTypes();
            if (paramTypes.length == 0) {
                return StringUtils.EMPTY_STRING_ARRAY;
            }
            String descriptor = JavassistParameterNameReader.getDescriptor(paramTypes, Void.TYPE);
            Class<?> clazz = ctor.getDeclaringClass();
            CtConstructor ctCtor = this.getClassPool(clazz).get(clazz.getName()).getConstructor(descriptor);
            return JavassistParameterNameReader.read((CtBehavior)ctCtor, 1, paramTypes.length);
        }
        catch (Throwable t) {
            LOG.warn("99-0", "", "", "Read parameter names error", t);
            return null;
        }
    }

    private static String getDescriptor(Class<?>[] parameterTypes, Class<?> returnType) {
        StringBuilder descriptor = new StringBuilder(32);
        descriptor.append('(');
        for (Class<?> type : parameterTypes) {
            descriptor.append(JavassistParameterNameReader.toJvmName(type));
        }
        descriptor.append(')');
        descriptor.append(JavassistParameterNameReader.toJvmName(returnType));
        return descriptor.toString();
    }

    private static String toJvmName(Class<?> clazz) {
        return clazz.isArray() ? Descriptor.toJvmName((String)clazz.getName()) : Descriptor.of((String)clazz.getName());
    }

    private ClassPool getClassPool(Class<?> clazz) {
        ClassLoader classLoader = ClassUtils.getClassLoader(clazz);
        return this.classPoolMap.computeIfAbsent(System.identityHashCode(classLoader), k -> {
            ClassPool pool = new ClassPool();
            pool.appendClassPath((ClassPath)new LoaderClassPath(classLoader));
            return pool;
        });
    }

    private static String[] read(CtBehavior behavior, int start, int len) {
        if (behavior == null) {
            return null;
        }
        CodeAttribute codeAttr = behavior.getMethodInfo().getCodeAttribute();
        if (codeAttr == null) {
            return null;
        }
        LocalVariableAttribute attr = (LocalVariableAttribute)codeAttr.getAttribute("LocalVariableTable");
        if (attr == null) {
            return null;
        }
        String[] names = new String[len];
        int tLen = attr.tableLength();
        for (int i = 0; i < tLen; ++i) {
            int j = attr.index(i) - start;
            if (j < 0 || j >= len) continue;
            names[j] = attr.variableName(i);
        }
        return names;
    }
}

