/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.gen;

import com.google.common.base.Strings;
import com.google.common.html.HtmlEscapers;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.compiler.PluginProtos;
import com.salesforce.jprotoc.Generator;
import com.salesforce.jprotoc.GeneratorException;
import com.salesforce.jprotoc.ProtoTypeMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class AbstractGenerator
extends Generator {
    private static final int SERVICE_NUMBER_OF_PATHS = 2;
    private static final int METHOD_NUMBER_OF_PATHS = 4;

    protected abstract String getClassPrefix();

    protected abstract String getClassSuffix();

    protected String getSingleTemplateFileName() {
        return this.getTemplateFileName();
    }

    protected String getTemplateFileName() {
        return this.getClassPrefix() + this.getClassSuffix() + "Stub.mustache";
    }

    protected String getInterfaceTemplateFileName() {
        return this.getClassPrefix() + this.getClassSuffix() + "InterfaceStub.mustache";
    }

    protected List<PluginProtos.CodeGeneratorResponse.Feature> supportedFeatures() {
        return Collections.singletonList(PluginProtos.CodeGeneratorResponse.Feature.FEATURE_PROTO3_OPTIONAL);
    }

    private String getServiceJavaDocPrefix() {
        return "    ";
    }

    private String getMethodJavaDocPrefix() {
        return "        ";
    }

    public List<PluginProtos.CodeGeneratorResponse.File> generateFiles(PluginProtos.CodeGeneratorRequest request) throws GeneratorException {
        ProtoTypeMap typeMap = ProtoTypeMap.of((Collection)request.getProtoFileList());
        List<DescriptorProtos.FileDescriptorProto> protosToGenerate = request.getProtoFileList().stream().filter(protoFile -> request.getFileToGenerateList().contains((Object)protoFile.getName())).collect(Collectors.toList());
        List<ServiceContext> services = this.findServices(protosToGenerate, typeMap);
        return this.generateFiles(services);
    }

    private List<ServiceContext> findServices(List<DescriptorProtos.FileDescriptorProto> protos, ProtoTypeMap typeMap) {
        ArrayList<ServiceContext> contexts = new ArrayList<ServiceContext>();
        protos.forEach(fileProto -> {
            for (int serviceNumber = 0; serviceNumber < fileProto.getServiceCount(); ++serviceNumber) {
                ServiceContext serviceContext = this.buildServiceContext(fileProto.getService(serviceNumber), typeMap, fileProto.getSourceCodeInfo().getLocationList(), serviceNumber);
                serviceContext.protoName = fileProto.getName();
                serviceContext.packageName = this.extractPackageName((DescriptorProtos.FileDescriptorProto)fileProto);
                if (!Strings.isNullOrEmpty((String)fileProto.getOptions().getJavaOuterClassname())) {
                    serviceContext.outerClassName = fileProto.getOptions().getJavaOuterClassname();
                }
                serviceContext.commonPackageName = this.extractCommonPackageName((DescriptorProtos.FileDescriptorProto)fileProto);
                serviceContext.multipleFiles = fileProto.getOptions() != null && fileProto.getOptions().getJavaMultipleFiles();
                contexts.add(serviceContext);
            }
        });
        return contexts;
    }

    private String extractPackageName(DescriptorProtos.FileDescriptorProto proto) {
        String javaPackage;
        DescriptorProtos.FileOptions options = proto.getOptions();
        if (options != null && !Strings.isNullOrEmpty((String)(javaPackage = options.getJavaPackage()))) {
            return javaPackage;
        }
        return Strings.nullToEmpty((String)proto.getPackage());
    }

    private String extractCommonPackageName(DescriptorProtos.FileDescriptorProto proto) {
        return Strings.nullToEmpty((String)proto.getPackage());
    }

    private ServiceContext buildServiceContext(DescriptorProtos.ServiceDescriptorProto serviceProto, ProtoTypeMap typeMap, List<DescriptorProtos.SourceCodeInfo.Location> locations, int serviceNumber) {
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.fileName = this.getClassPrefix() + serviceProto.getName() + this.getClassSuffix() + ".java";
        serviceContext.className = this.getClassPrefix() + serviceProto.getName() + this.getClassSuffix();
        serviceContext.outerClassName = serviceProto.getName() + "OuterClass";
        serviceContext.interfaceFileName = serviceProto.getName() + ".java";
        serviceContext.interfaceClassName = serviceProto.getName();
        serviceContext.serviceName = serviceProto.getName();
        serviceContext.deprecated = serviceProto.getOptions() != null && serviceProto.getOptions().getDeprecated();
        List allLocationsForService = locations.stream().filter(location -> location.getPathCount() >= 2 && location.getPath(0) == 6 && location.getPath(1) == serviceNumber).collect(Collectors.toList());
        DescriptorProtos.SourceCodeInfo.Location serviceLocation = allLocationsForService.stream().filter(location -> location.getPathCount() == 2).findFirst().orElseGet(DescriptorProtos.SourceCodeInfo.Location::getDefaultInstance);
        serviceContext.javaDoc = this.getJavaDoc(this.getComments(serviceLocation), this.getServiceJavaDocPrefix());
        for (int methodNumber = 0; methodNumber < serviceProto.getMethodCount(); ++methodNumber) {
            MethodContext methodContext = this.buildMethodContext(serviceProto.getMethod(methodNumber), typeMap, locations, methodNumber);
            serviceContext.methods.add(methodContext);
            serviceContext.methodTypes.add(methodContext.inputType);
            serviceContext.methodTypes.add(methodContext.outputType);
        }
        return serviceContext;
    }

    private MethodContext buildMethodContext(DescriptorProtos.MethodDescriptorProto methodProto, ProtoTypeMap typeMap, List<DescriptorProtos.SourceCodeInfo.Location> locations, int methodNumber) {
        MethodContext methodContext = new MethodContext();
        methodContext.originMethodName = methodProto.getName();
        methodContext.methodName = this.lowerCaseFirst(methodProto.getName());
        methodContext.inputType = typeMap.toJavaTypeName(methodProto.getInputType());
        methodContext.outputType = typeMap.toJavaTypeName(methodProto.getOutputType());
        methodContext.deprecated = methodProto.getOptions() != null && methodProto.getOptions().getDeprecated();
        methodContext.isManyInput = methodProto.getClientStreaming();
        methodContext.isManyOutput = methodProto.getServerStreaming();
        methodContext.methodNumber = methodNumber;
        DescriptorProtos.SourceCodeInfo.Location methodLocation = locations.stream().filter(location -> location.getPathCount() == 4 && location.getPath(3) == methodNumber).findFirst().orElseGet(DescriptorProtos.SourceCodeInfo.Location::getDefaultInstance);
        methodContext.javaDoc = this.getJavaDoc(this.getComments(methodLocation), this.getMethodJavaDocPrefix());
        if (!methodProto.getClientStreaming() && !methodProto.getServerStreaming()) {
            methodContext.reactiveCallsMethodName = "oneToOne";
            methodContext.grpcCallsMethodName = "asyncUnaryCall";
        }
        if (!methodProto.getClientStreaming() && methodProto.getServerStreaming()) {
            methodContext.reactiveCallsMethodName = "oneToMany";
            methodContext.grpcCallsMethodName = "asyncServerStreamingCall";
        }
        if (methodProto.getClientStreaming() && !methodProto.getServerStreaming()) {
            methodContext.reactiveCallsMethodName = "manyToOne";
            methodContext.grpcCallsMethodName = "asyncClientStreamingCall";
        }
        if (methodProto.getClientStreaming() && methodProto.getServerStreaming()) {
            methodContext.reactiveCallsMethodName = "manyToMany";
            methodContext.grpcCallsMethodName = "asyncBidiStreamingCall";
        }
        return methodContext;
    }

    private String lowerCaseFirst(String s) {
        return Character.toLowerCase(s.charAt(0)) + s.substring(1);
    }

    private List<PluginProtos.CodeGeneratorResponse.File> generateFiles(List<ServiceContext> services) {
        ArrayList<PluginProtos.CodeGeneratorResponse.File> allServiceFiles = new ArrayList<PluginProtos.CodeGeneratorResponse.File>();
        for (ServiceContext context : services) {
            List<PluginProtos.CodeGeneratorResponse.File> files = this.buildFile(context);
            allServiceFiles.addAll(files);
        }
        return allServiceFiles;
    }

    protected boolean enableMultipleTemplateFiles() {
        return false;
    }

    private List<PluginProtos.CodeGeneratorResponse.File> buildFile(ServiceContext context) {
        ArrayList<PluginProtos.CodeGeneratorResponse.File> files = new ArrayList<PluginProtos.CodeGeneratorResponse.File>();
        if (context.multipleFiles && this.enableMultipleTemplateFiles()) {
            String content = this.applyTemplate(this.getTemplateFileName(), context);
            String dir = this.absoluteDir(context);
            files.add(PluginProtos.CodeGeneratorResponse.File.newBuilder().setName(this.getFileName(dir, context.fileName)).setContent(content).build());
            content = this.applyTemplate(this.getInterfaceTemplateFileName(), context);
            files.add(PluginProtos.CodeGeneratorResponse.File.newBuilder().setName(this.getFileName(dir, context.interfaceFileName)).setContent(content).build());
        } else {
            String content = this.applyTemplate(this.getSingleTemplateFileName(), context);
            String dir = this.absoluteDir(context);
            files.add(PluginProtos.CodeGeneratorResponse.File.newBuilder().setName(this.getFileName(dir, context.fileName)).setContent(content).build());
        }
        return files;
    }

    private String absoluteDir(ServiceContext ctx) {
        return ctx.packageName.replace('.', '/');
    }

    private String getFileName(String dir, String fileName) {
        if (Strings.isNullOrEmpty((String)dir)) {
            return fileName;
        }
        return dir + "/" + fileName;
    }

    private String getComments(DescriptorProtos.SourceCodeInfo.Location location) {
        return location.getLeadingComments().isEmpty() ? location.getTrailingComments() : location.getLeadingComments();
    }

    private String getJavaDoc(String comments, String prefix) {
        if (!comments.isEmpty()) {
            StringBuilder builder = new StringBuilder("/**\n").append(prefix).append(" * <pre>\n");
            Arrays.stream(HtmlEscapers.htmlEscaper().escape(comments).split("\n")).map(line -> line.replace("*/", "&#42;&#47;").replace("*", "&#42;")).forEach(line -> builder.append(prefix).append(" * ").append((String)line).append("\n"));
            builder.append(prefix).append(" * </pre>\n").append(prefix).append(" */");
            return builder.toString();
        }
        return null;
    }

    private class MethodContext {
        public String originMethodName;
        public String methodName;
        public String inputType;
        public String outputType;
        public boolean deprecated;
        public boolean isManyInput;
        public boolean isManyOutput;
        public String reactiveCallsMethodName;
        public String grpcCallsMethodName;
        public int methodNumber;
        public String javaDoc;

        private MethodContext() {
        }

        public String methodNameUpperUnderscore() {
            StringBuilder s = new StringBuilder();
            for (int i = 0; i < this.methodName.length(); ++i) {
                char c = this.methodName.charAt(i);
                s.append(Character.toUpperCase(c));
                if (i >= this.methodName.length() - 1 || !Character.isLowerCase(c) || !Character.isUpperCase(this.methodName.charAt(i + 1))) continue;
                s.append('_');
            }
            return s.toString();
        }

        public String methodNamePascalCase() {
            String mn = this.methodName.replace("_", "");
            return String.valueOf(Character.toUpperCase(mn.charAt(0))) + mn.substring(1);
        }

        public String methodNameCamelCase() {
            String mn = this.methodName.replace("_", "");
            return String.valueOf(Character.toLowerCase(mn.charAt(0))) + mn.substring(1);
        }
    }

    private class ServiceContext {
        public String fileName;
        public String interfaceFileName;
        public String protoName;
        public String packageName;
        public String commonPackageName;
        public String className;
        public String interfaceClassName;
        public String serviceName;
        public boolean deprecated;
        public String javaDoc;
        public boolean multipleFiles;
        public String outerClassName;
        public List<MethodContext> methods = new ArrayList<MethodContext>();
        public Set<String> methodTypes = new HashSet<String>();

        private ServiceContext() {
        }

        public List<MethodContext> unaryRequestMethods() {
            return this.methods.stream().filter(m -> !m.isManyInput).collect(Collectors.toList());
        }

        public List<MethodContext> unaryMethods() {
            return this.methods.stream().filter(m -> !m.isManyInput && !m.isManyOutput).collect(Collectors.toList());
        }

        public List<MethodContext> serverStreamingMethods() {
            return this.methods.stream().filter(m -> !m.isManyInput && m.isManyOutput).collect(Collectors.toList());
        }

        public List<MethodContext> biStreamingMethods() {
            return this.methods.stream().filter(m -> m.isManyInput).collect(Collectors.toList());
        }

        public List<MethodContext> biStreamingWithoutClientStreamMethods() {
            return this.methods.stream().filter(m -> m.isManyInput && m.isManyOutput).collect(Collectors.toList());
        }

        public List<MethodContext> clientStreamingMethods() {
            return this.methods.stream().filter(m -> m.isManyInput && !m.isManyOutput).collect(Collectors.toList());
        }

        public List<MethodContext> methods() {
            return this.methods;
        }
    }
}

