/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.metadata;

import org.apache.dubbo.common.deploy.ApplicationDeployListener;
import org.apache.dubbo.common.lang.Prioritized;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.config.metadata.ConfigurableMetadataServiceExporter;
import org.apache.dubbo.registry.client.metadata.MetadataServiceDelegation;
import org.apache.dubbo.rpc.model.ApplicationModel;

public class ExporterDeployListener
implements ApplicationDeployListener,
Prioritized {
    protected volatile ConfigurableMetadataServiceExporter metadataServiceExporter;

    public void onInitialize(ApplicationModel scopeModel) {
    }

    public void onStarting(ApplicationModel scopeModel) {
    }

    public synchronized void onStarted(ApplicationModel applicationModel) {
    }

    public synchronized void onStopping(ApplicationModel scopeModel) {
    }

    private String getMetadataType(ApplicationModel applicationModel) {
        String type = applicationModel.getApplicationConfigManager().getApplicationOrElseThrow().getMetadataType();
        if (StringUtils.isEmpty((String)type)) {
            type = "local";
        }
        return type;
    }

    public ConfigurableMetadataServiceExporter getMetadataServiceExporter() {
        return this.metadataServiceExporter;
    }

    public void setMetadataServiceExporter(ConfigurableMetadataServiceExporter metadataServiceExporter) {
        this.metadataServiceExporter = metadataServiceExporter;
    }

    public synchronized void onModuleStarted(ApplicationModel applicationModel) {
        MetadataServiceDelegation metadataService = (MetadataServiceDelegation)applicationModel.getBeanFactory().getOrRegisterBean(MetadataServiceDelegation.class);
        if (this.metadataServiceExporter == null) {
            this.metadataServiceExporter = new ConfigurableMetadataServiceExporter(applicationModel, metadataService);
            if (!"remote".equals(this.getMetadataType(applicationModel))) {
                this.metadataServiceExporter.export();
            }
        }
    }

    public synchronized void onStopped(ApplicationModel scopeModel) {
        if (this.metadataServiceExporter != null && this.metadataServiceExporter.isExported()) {
            try {
                this.metadataServiceExporter.unexport();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void onFailure(ApplicationModel scopeModel, Throwable cause) {
    }

    public int getPriority() {
        return Integer.MIN_VALUE;
    }
}

