/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config;

import java.beans.Transient;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.URLBuilder;
import org.apache.dubbo.common.Version;
import org.apache.dubbo.common.config.ConfigurationUtils;
import org.apache.dubbo.common.constants.RegisterTypeEnum;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.threadpool.manager.ExecutorRepository;
import org.apache.dubbo.common.threadpool.manager.FrameworkExecutorRepository;
import org.apache.dubbo.common.url.component.ServiceConfigURL;
import org.apache.dubbo.common.utils.ClassUtils;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.ConfigUtils;
import org.apache.dubbo.common.utils.NetUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.config.AbstractConfig;
import org.apache.dubbo.config.AbstractInterfaceConfig;
import org.apache.dubbo.config.ArgumentConfig;
import org.apache.dubbo.config.ConfigInitializer;
import org.apache.dubbo.config.ConfigPostProcessor;
import org.apache.dubbo.config.MethodConfig;
import org.apache.dubbo.config.ProtocolConfig;
import org.apache.dubbo.config.ProviderConfig;
import org.apache.dubbo.config.ServiceConfigBase;
import org.apache.dubbo.config.ServiceListener;
import org.apache.dubbo.config.annotation.Service;
import org.apache.dubbo.config.invoker.DelegateProviderMetaDataInvoker;
import org.apache.dubbo.config.support.Parameter;
import org.apache.dubbo.config.utils.ConfigValidationUtils;
import org.apache.dubbo.metadata.ServiceNameMapping;
import org.apache.dubbo.metrics.event.MetricsEvent;
import org.apache.dubbo.metrics.event.MetricsEventBus;
import org.apache.dubbo.metrics.event.MetricsInitEvent;
import org.apache.dubbo.metrics.model.MethodMetric;
import org.apache.dubbo.registry.client.metadata.MetadataUtils;
import org.apache.dubbo.rpc.Exporter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Protocol;
import org.apache.dubbo.rpc.ProxyFactory;
import org.apache.dubbo.rpc.RpcInvocation;
import org.apache.dubbo.rpc.ServerService;
import org.apache.dubbo.rpc.cluster.ConfiguratorFactory;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.ModuleModel;
import org.apache.dubbo.rpc.model.ModuleServiceRepository;
import org.apache.dubbo.rpc.model.ProviderModel;
import org.apache.dubbo.rpc.model.ScopeModel;
import org.apache.dubbo.rpc.model.ServiceDescriptor;
import org.apache.dubbo.rpc.model.ServiceModel;
import org.apache.dubbo.rpc.service.GenericService;
import org.apache.dubbo.rpc.support.ProtocolUtils;

public class ServiceConfig<T>
extends ServiceConfigBase<T> {
    private static final long serialVersionUID = 7868244018230856253L;
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(ServiceConfig.class);
    private static final Map<String, Integer> RANDOM_PORT_MAP = new HashMap<String, Integer>();
    private Protocol protocolSPI;
    private ProxyFactory proxyFactory;
    private ProviderModel providerModel;
    private volatile transient boolean exported;
    private volatile transient boolean unexported;
    private volatile transient AtomicBoolean initialized = new AtomicBoolean(false);
    private final Map<RegisterTypeEnum, List<Exporter<?>>> exporters = new ConcurrentHashMap();
    private final List<ServiceListener> serviceListeners = new ArrayList<ServiceListener>();

    public ServiceConfig() {
    }

    public ServiceConfig(ModuleModel moduleModel) {
        super(moduleModel);
    }

    public ServiceConfig(Service service) {
        super(service);
    }

    public ServiceConfig(ModuleModel moduleModel, Service service) {
        super(moduleModel, service);
    }

    protected void postProcessAfterScopeModelChanged(ScopeModel oldScopeModel, ScopeModel newScopeModel) {
        super.postProcessAfterScopeModelChanged(oldScopeModel, newScopeModel);
        this.protocolSPI = (Protocol)this.getExtensionLoader(Protocol.class).getAdaptiveExtension();
        this.proxyFactory = (ProxyFactory)this.getExtensionLoader(ProxyFactory.class).getAdaptiveExtension();
    }

    @Parameter(excluded=true, attribute=false)
    public boolean isExported() {
        return this.exported;
    }

    @Parameter(excluded=true, attribute=false)
    public boolean isUnexported() {
        return this.unexported;
    }

    public synchronized void unexport() {
        if (!this.exported) {
            return;
        }
        if (this.unexported) {
            return;
        }
        if (!this.exporters.isEmpty()) {
            for (List<Exporter<?>> es : this.exporters.values()) {
                for (Exporter<?> exporter : es) {
                    try {
                        exporter.unregister();
                    }
                    catch (Throwable t) {
                        logger.warn("5-7", "", "", "Unexpected error occurred when unexport " + exporter, t);
                    }
                }
            }
            this.waitForIdle();
            for (List<Exporter<?>> es : this.exporters.values()) {
                for (Exporter<?> exporter : es) {
                    try {
                        exporter.unexport();
                    }
                    catch (Throwable t) {
                        logger.warn("5-7", "", "", "Unexpected error occurred when unexport " + exporter, t);
                    }
                }
            }
            this.exporters.clear();
        }
        this.unexported = true;
        this.onUnexpoted();
        ModuleServiceRepository repository = this.getScopeModel().getServiceRepository();
        repository.unregisterProvider(this.providerModel);
    }

    private void waitForIdle() {
        int timeout = ConfigurationUtils.getServerShutdownTimeout((ScopeModel)this.getScopeModel());
        long idleTime = System.currentTimeMillis() - this.providerModel.getLastInvokeTime();
        if (idleTime > (long)timeout) {
            return;
        }
        int tick = timeout / 3;
        if ((long)timeout - idleTime < (long)tick) {
            logger.info("Service " + this.getUniqueServiceName() + " has idle for " + idleTime + " ms, wait for " + ((long)timeout - idleTime) + " ms to un-export");
            try {
                Thread.sleep((long)timeout - idleTime);
            }
            catch (InterruptedException e) {
                logger.warn("99-0", "unknown error in registry module", "", e.getMessage(), (Throwable)e);
                Thread.currentThread().interrupt();
            }
            return;
        }
        idleTime = 0L;
        long startTime = System.currentTimeMillis();
        while (idleTime < (long)tick) {
            idleTime = System.currentTimeMillis() - Math.max(this.providerModel.getLastInvokeTime(), startTime);
            if (idleTime >= (long)tick || System.currentTimeMillis() - startTime > (long)timeout) {
                return;
            }
            long waitTime = Math.min((long)tick - idleTime, (long)timeout + startTime - System.currentTimeMillis());
            logger.info("Service " + this.getUniqueServiceName() + " has idle for " + idleTime + " ms, wait for " + waitTime + " ms to un-export");
            try {
                Thread.sleep(waitTime);
            }
            catch (InterruptedException e) {
                logger.warn("99-0", "unknown error in registry module", "", e.getMessage(), (Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
    }

    public void init() {
        if (this.initialized.compareAndSet(false, true)) {
            ExtensionLoader extensionLoader = this.getExtensionLoader(ServiceListener.class);
            this.serviceListeners.addAll(extensionLoader.getSupportedExtensionInstances());
        }
        this.initServiceMetadata((AbstractInterfaceConfig)this.provider);
        this.serviceMetadata.setServiceType(this.getInterfaceClass());
        this.serviceMetadata.setTarget(this.getRef());
        this.serviceMetadata.generateServiceKey();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void export(RegisterTypeEnum registerType) {
        if (this.exported) {
            return;
        }
        if (this.getScopeModel().isLifeCycleManagedExternally()) {
            this.getScopeModel().getDeployer().prepare();
        } else {
            this.getScopeModel().getDeployer().start();
        }
        ServiceConfig serviceConfig = this;
        synchronized (serviceConfig) {
            if (this.exported) {
                return;
            }
            if (!this.isRefreshed()) {
                this.refresh();
            }
            if (this.shouldExport()) {
                this.init();
                if (this.shouldDelay()) {
                    this.doDelayExport();
                } else if (Integer.valueOf(-1).equals(this.getDelay()) && Boolean.parseBoolean(ConfigurationUtils.getProperty((ScopeModel)this.getScopeModel(), (String)"dubbo.application.manual-register", (String)"false"))) {
                    this.doExport(RegisterTypeEnum.MANUAL_REGISTER);
                } else {
                    this.doExport(registerType);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(boolean byDeployer) {
        if (!this.exported) {
            return;
        }
        ServiceConfig serviceConfig = this;
        synchronized (serviceConfig) {
            if (!this.exported) {
                return;
            }
            for (Exporter exporter : this.exporters.getOrDefault(RegisterTypeEnum.AUTO_REGISTER, Collections.emptyList())) {
                exporter.register();
            }
            if (byDeployer) {
                for (Exporter exporter : this.exporters.getOrDefault(RegisterTypeEnum.AUTO_REGISTER_BY_DEPLOYER, Collections.emptyList())) {
                    exporter.register();
                }
            }
        }
    }

    protected void doDelayExport() {
        ExecutorRepository.getInstance((ApplicationModel)this.getScopeModel().getApplicationModel()).getServiceExportExecutor().schedule(() -> {
            try {
                this.doExport(RegisterTypeEnum.AUTO_REGISTER);
            }
            catch (Exception e) {
                logger.error("5-9", "configuration server disconnected", "", "Failed to (async)export service config: " + this.interfaceName, (Throwable)e);
            }
        }, (long)this.getDelay().intValue(), TimeUnit.MILLISECONDS);
    }

    protected void exported() {
        this.exported = true;
        List exportedURLs = this.getExportedUrls();
        exportedURLs.forEach(url -> {
            if (url.getParameters().containsKey("service-name-mapping")) {
                ServiceNameMapping serviceNameMapping = ServiceNameMapping.getDefaultExtension((ScopeModel)this.getScopeModel());
                ScheduledExecutorService scheduledExecutor = ((FrameworkExecutorRepository)this.getScopeModel().getBeanFactory().getBean(FrameworkExecutorRepository.class)).getSharedScheduledExecutor();
                this.mapServiceName((URL)url, serviceNameMapping, scheduledExecutor);
            }
        });
        this.onExported();
    }

    protected void mapServiceName(URL url, ServiceNameMapping serviceNameMapping, ScheduledExecutorService scheduledExecutor) {
        if (!this.exported) {
            return;
        }
        logger.info("Try to register interface application mapping for service " + url.getServiceKey());
        boolean succeeded = false;
        try {
            succeeded = serviceNameMapping.map(url);
            if (succeeded) {
                logger.info("Successfully registered interface application mapping for service " + url.getServiceKey());
            } else {
                logger.error("5-10", "configuration server disconnected", "", "Failed register interface application mapping for service " + url.getServiceKey());
            }
        }
        catch (Exception e) {
            logger.error("5-10", "configuration server disconnected", "", "Failed register interface application mapping for service " + url.getServiceKey(), (Throwable)e);
        }
        if (!succeeded && serviceNameMapping.hasValidMetadataCenter()) {
            this.scheduleToMapping(scheduledExecutor, serviceNameMapping, url);
        }
    }

    private void scheduleToMapping(ScheduledExecutorService scheduledExecutor, ServiceNameMapping serviceNameMapping, URL url) {
        Integer mappingRetryInterval = this.getApplication().getMappingRetryInterval();
        scheduledExecutor.schedule(() -> this.mapServiceName(url, serviceNameMapping, scheduledExecutor), mappingRetryInterval == null ? 5000L : (long)mappingRetryInterval.intValue(), TimeUnit.MILLISECONDS);
    }

    private void checkAndUpdateSubConfigs() {
        this.completeCompoundConfigs();
        this.checkProtocol();
        List configInitializers = this.getExtensionLoader(ConfigInitializer.class).getActivateExtension(URL.valueOf((String)"configInitializer://", (ScopeModel)this.getScopeModel()), (String[])null);
        configInitializers.forEach(e -> e.initServiceConfig(this));
        if (!this.isOnlyInJvm()) {
            this.checkRegistry();
        }
        if (StringUtils.isEmpty((String)this.interfaceName)) {
            throw new IllegalStateException("<dubbo:service interface=\"\" /> interface not allow null!");
        }
        if (this.ref instanceof GenericService) {
            this.interfaceClass = GenericService.class;
            if (StringUtils.isEmpty((String)this.generic)) {
                this.generic = Boolean.TRUE.toString();
            }
        } else {
            try {
                this.interfaceClass = this.getInterfaceClassLoader() != null ? Class.forName(this.interfaceName, true, this.getInterfaceClassLoader()) : Class.forName(this.interfaceName, true, Thread.currentThread().getContextClassLoader());
            }
            catch (ClassNotFoundException e2) {
                throw new IllegalStateException(e2.getMessage(), e2);
            }
            this.checkRef();
            this.generic = Boolean.FALSE.toString();
        }
        if (this.local != null) {
            Class localClass;
            if ("true".equals(this.local)) {
                this.local = this.interfaceName + "Local";
            }
            try {
                localClass = ClassUtils.forNameWithThreadContextClassLoader((String)this.local);
            }
            catch (ClassNotFoundException e3) {
                throw new IllegalStateException(e3.getMessage(), e3);
            }
            if (!this.interfaceClass.isAssignableFrom(localClass)) {
                throw new IllegalStateException("The local implementation class " + localClass.getName() + " not implement interface " + this.interfaceName);
            }
        }
        if (this.stub != null) {
            Class stubClass;
            if ("true".equals(this.stub)) {
                this.stub = this.interfaceName + "Stub";
            }
            try {
                stubClass = ClassUtils.forNameWithThreadContextClassLoader((String)this.stub);
            }
            catch (ClassNotFoundException e4) {
                throw new IllegalStateException(e4.getMessage(), e4);
            }
            if (!this.interfaceClass.isAssignableFrom(stubClass)) {
                throw new IllegalStateException("The stub implementation class " + stubClass.getName() + " not implement interface " + this.interfaceName);
            }
        }
        this.checkStubAndLocal(this.interfaceClass);
        ConfigValidationUtils.checkMock(this.interfaceClass, (AbstractInterfaceConfig)this);
        ConfigValidationUtils.validateServiceConfig(this);
        this.postProcessConfig();
    }

    protected void postProcessRefresh() {
        super.postProcessRefresh();
        this.checkAndUpdateSubConfigs();
    }

    protected synchronized void doExport(RegisterTypeEnum registerType) {
        if (this.unexported) {
            throw new IllegalStateException("The service " + this.interfaceClass.getName() + " has already unexported!");
        }
        if (this.exported) {
            return;
        }
        if (StringUtils.isEmpty((String)this.path)) {
            this.path = this.interfaceName;
        }
        this.doExportUrls(registerType);
        this.exported();
    }

    private void doExportUrls(RegisterTypeEnum registerType) {
        ServiceDescriptor serviceDescriptor;
        ModuleServiceRepository repository = this.getScopeModel().getServiceRepository();
        boolean serverService = this.ref instanceof ServerService;
        if (serverService) {
            serviceDescriptor = ((ServerService)this.ref).getServiceDescriptor();
            if (!this.provider.getUseJavaPackageAsPath().booleanValue()) {
                this.path = serviceDescriptor.getInterfaceName();
            }
            repository.registerService(serviceDescriptor);
        } else {
            serviceDescriptor = repository.registerService(this.getInterfaceClass());
        }
        this.providerModel = new ProviderModel(this.serviceMetadata.getServiceKey(), this.ref, serviceDescriptor, this.getScopeModel(), this.serviceMetadata, this.interfaceClassLoader);
        this.providerModel.setConfig((AbstractInterfaceConfig)this);
        this.providerModel.setDestroyRunner(this.getDestroyRunner());
        repository.registerProvider(this.providerModel);
        List<URL> registryURLs = ConfigValidationUtils.loadRegistries((AbstractInterfaceConfig)this, true);
        for (ProtocolConfig protocolConfig : this.protocols) {
            String pathKey = URL.buildKey((String)this.getContextPath(protocolConfig).map(p -> p + "/" + this.path).orElse(this.path), (String)this.group, (String)this.version);
            if (!serverService) {
                repository.registerService(pathKey, this.interfaceClass);
            }
            this.doExportUrlsFor1Protocol(protocolConfig, registryURLs, registerType);
        }
        this.providerModel.setServiceUrls(this.urls);
    }

    private void doExportUrlsFor1Protocol(ProtocolConfig protocolConfig, List<URL> registryURLs, RegisterTypeEnum registerType) {
        Map<String, String> map = this.buildAttributes(protocolConfig);
        map.keySet().removeIf(key -> StringUtils.isEmpty((String)key) || StringUtils.isEmpty((String)((String)map.get(key))));
        this.serviceMetadata.getAttachments().putAll(map);
        URL url = this.buildUrl(protocolConfig, map);
        this.processServiceExecutor(url);
        this.exportUrl(url, registryURLs, registerType);
        this.initServiceMethodMetrics(url);
    }

    private void initServiceMethodMetrics(URL url) {
        String[] methods = Optional.ofNullable(url.getParameter("methods")).map(i -> i.split(",")).orElse(new String[0]);
        boolean serviceLevel = MethodMetric.isServiceLevel((ApplicationModel)this.application.getApplicationModel());
        Arrays.stream(methods).forEach(method -> {
            RpcInvocation invocation = new RpcInvocation(url.getServiceKey(), url.getServiceModel(), method, this.interfaceName, url.getProtocolServiceKey(), null, null, null, null, null, null);
            MetricsEventBus.publish((MetricsEvent)MetricsInitEvent.toMetricsInitEvent((ApplicationModel)this.application.getApplicationModel(), (Invocation)invocation, (boolean)serviceLevel));
        });
    }

    private void processServiceExecutor(URL url) {
        if (this.getExecutor() != null) {
            String mode = this.application.getExecutorManagementMode();
            if (!"isolation".equals(mode)) {
                logger.warn("0-27", "", "", "The current executor management mode is " + mode + ", the configured service executor cannot take effect unless the mode is configured as " + "isolation");
                return;
            }
            this.providerModel.getServiceMetadata().addAttribute("service-executor", (Object)this.getExecutor());
            url.getAttributes().put("service-executor", this.getExecutor());
        }
    }

    private Map<String, String> buildAttributes(ProtocolConfig protocolConfig) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("side", "provider");
        ServiceConfig.appendRuntimeParameters(map);
        AbstractConfig.appendParameters(map, (Object)this.getApplication());
        AbstractConfig.appendParameters(map, (Object)this.getModule());
        AbstractConfig.appendParameters(map, (Object)this.provider);
        AbstractConfig.appendParameters(map, (Object)protocolConfig);
        AbstractConfig.appendParameters(map, (Object)((Object)this));
        this.appendMetricsCompatible(map);
        if (CollectionUtils.isNotEmpty((Collection)this.getMethods())) {
            this.getMethods().forEach(method -> this.appendParametersWithMethod((MethodConfig)method, (Map<String, String>)map));
        }
        if (ProtocolUtils.isGeneric((String)this.generic)) {
            map.put("generic", this.generic);
            map.put("methods", "*");
        } else {
            String[] methods;
            String revision = Version.getVersion((Class)this.interfaceClass, (String)this.version);
            if (StringUtils.isNotEmpty((String)revision)) {
                map.put("revision", revision);
            }
            if ((methods = this.methods(this.interfaceClass)).length == 0) {
                logger.warn("5-4", "", "", "No method found in service interface: " + this.interfaceClass.getName());
                map.put("methods", "*");
            } else {
                map.put("methods", StringUtils.join(new TreeSet<String>(Arrays.asList(methods)), (String)","));
            }
        }
        if (ConfigUtils.isEmpty((String)this.token) && this.provider != null) {
            this.token = this.provider.getToken();
        }
        if (!ConfigUtils.isEmpty((String)this.token)) {
            if (ConfigUtils.isDefault((String)this.token)) {
                map.put("token", UUID.randomUUID().toString());
            } else {
                map.put("token", this.token);
            }
        }
        if (this.ref instanceof ServerService) {
            map.put("proxy", "nativestub");
        }
        return map;
    }

    private void appendParametersWithMethod(MethodConfig method, Map<String, String> params) {
        Method matchedMethod;
        List arguments;
        String retryValue;
        AbstractConfig.appendParameters(params, (Object)method, (String)method.getName());
        String retryKey = method.getName() + ".retry";
        if (params.containsKey(retryKey) && "false".equals(retryValue = params.remove(retryKey))) {
            params.put(method.getName() + ".retries", "0");
        }
        if (CollectionUtils.isNotEmpty((Collection)(arguments = method.getArguments())) && (matchedMethod = this.findMatchedMethod(method)) != null) {
            arguments.forEach(argument -> this.appendArgumentConfig((ArgumentConfig)argument, matchedMethod, params));
        }
    }

    private Method findMatchedMethod(MethodConfig methodConfig) {
        for (Method method : this.interfaceClass.getMethods()) {
            if (!method.getName().equals(methodConfig.getName())) continue;
            return method;
        }
        return null;
    }

    private void appendArgumentConfig(ArgumentConfig argument, Method method, Map<String, String> params) {
        if (StringUtils.isNotEmpty((String)argument.getType())) {
            Integer index = this.findArgumentIndexIndexWithGivenType(argument, method);
            AbstractConfig.appendParameters(params, (Object)argument, (String)(method.getName() + "." + index));
        } else if (this.hasIndex(argument)) {
            AbstractConfig.appendParameters(params, (Object)argument, (String)(method.getName() + "." + argument.getIndex()));
        } else {
            throw new IllegalArgumentException("Argument config must set index or type attribute.eg: <dubbo:argument index='0' .../> or <dubbo:argument type=xxx .../>");
        }
    }

    private boolean hasIndex(ArgumentConfig argument) {
        return argument.getIndex() != -1;
    }

    private boolean isTypeMatched(String type, Integer index, Class<?>[] argtypes) {
        return index != null && index >= 0 && index < argtypes.length && argtypes[index].getName().equals(type);
    }

    private Integer findArgumentIndexIndexWithGivenType(ArgumentConfig argument, Method method) {
        Class<?>[] argTypes = method.getParameterTypes();
        if (this.hasIndex(argument)) {
            Integer index = argument.getIndex();
            String type = argument.getType();
            if (this.isTypeMatched(type, index, argTypes)) {
                return index;
            }
            throw new IllegalArgumentException("Argument config error : the index attribute and type attribute not match :index :" + argument.getIndex() + ", type:" + argument.getType());
        }
        for (int j = 0; j < argTypes.length; ++j) {
            if (!this.isTypeMatched(argument.getType(), j, argTypes)) continue;
            return j;
        }
        throw new IllegalArgumentException("Argument config error : no argument matched with the type:" + argument.getType());
    }

    private URL buildUrl(ProtocolConfig protocolConfig, Map<String, String> params) {
        String host;
        String name = protocolConfig.getName();
        if (StringUtils.isEmpty((String)name)) {
            name = "dubbo";
        }
        if (NetUtils.isIPV6URLStdFormat((String)(host = ServiceConfig.findConfiguredHosts(protocolConfig, this.provider, params)))) {
            if (!host.contains("[")) {
                host = "[" + host + "]";
            }
        } else if (NetUtils.getLocalHostV6() != null) {
            String ipv6Host = NetUtils.getLocalHostV6();
            params.put("ipv6", ipv6Host);
        }
        Integer port = ServiceConfig.findConfiguredPort(protocolConfig, this.provider, (ExtensionLoader<Protocol>)this.getExtensionLoader(Protocol.class), name, params);
        ServiceConfigURL url = new ServiceConfigURL(name, null, null, host, port.intValue(), this.getContextPath(protocolConfig).map(p -> p + "/" + this.path).orElse(this.path), params);
        if (this.getExtensionLoader(ConfiguratorFactory.class).hasExtension(url.getProtocol())) {
            url = ((ConfiguratorFactory)this.getExtensionLoader(ConfiguratorFactory.class).getExtension(url.getProtocol())).getConfigurator((URL)url).configure((URL)url);
        }
        url = url.setScopeModel((ScopeModel)this.getScopeModel());
        url = url.setServiceModel((ServiceModel)this.providerModel);
        return url;
    }

    private void exportUrl(URL url, List<URL> registryURLs, RegisterTypeEnum registerType) {
        String scope = url.getParameter("scope");
        if (!"none".equalsIgnoreCase(scope)) {
            if (!"remote".equalsIgnoreCase(scope)) {
                this.exportLocal(url);
            }
            if (!"local".equalsIgnoreCase(scope)) {
                String extProtocol = url.getParameter("ext.protocol", "");
                ArrayList<String> protocols = new ArrayList<String>();
                if (StringUtils.isNotBlank((CharSequence)extProtocol)) {
                    url = URLBuilder.from((URL)url).addParameter("ispuserver", Boolean.TRUE.toString()).removeParameter("ext.protocol").build();
                }
                url = this.exportRemote(url, registryURLs, registerType);
                if (!ProtocolUtils.isGeneric((String)this.generic) && !this.getScopeModel().isInternal()) {
                    MetadataUtils.publishServiceDefinition((URL)url, (ServiceDescriptor)this.providerModel.getServiceModel(), (ApplicationModel)this.getApplicationModel());
                }
                if (StringUtils.isNotBlank((CharSequence)extProtocol)) {
                    String[] extProtocols = extProtocol.split(",", -1);
                    protocols.addAll(Arrays.asList(extProtocols));
                }
                for (String protocol : protocols) {
                    if (!StringUtils.isNotBlank((CharSequence)protocol)) continue;
                    ServiceConfigURL localUrl = URLBuilder.from((URL)url).setProtocol(protocol).build();
                    localUrl = this.exportRemote((URL)localUrl, registryURLs, registerType);
                    if (!ProtocolUtils.isGeneric((String)this.generic) && !this.getScopeModel().isInternal()) {
                        MetadataUtils.publishServiceDefinition((URL)localUrl, (ServiceDescriptor)this.providerModel.getServiceModel(), (ApplicationModel)this.getApplicationModel());
                    }
                    this.urls.add(localUrl);
                }
            }
        }
        this.urls.add(url);
    }

    private URL exportRemote(URL url, List<URL> registryURLs, RegisterTypeEnum registerType) {
        if (CollectionUtils.isNotEmpty(registryURLs) && registerType != RegisterTypeEnum.NEVER_REGISTER) {
            for (URL registryURL : registryURLs) {
                String proxy;
                if ("service-discovery-registry".equals(registryURL.getProtocol())) {
                    url = url.addParameterIfAbsent("service-name-mapping", "true");
                }
                if ("injvm".equalsIgnoreCase(url.getProtocol())) continue;
                url = url.addParameterIfAbsent("dynamic", registryURL.getParameter("dynamic"));
                URL monitorUrl = ConfigValidationUtils.loadMonitor((AbstractInterfaceConfig)this, registryURL);
                if (monitorUrl != null) {
                    url = url.putAttribute("monitor", (Object)monitorUrl);
                }
                if (StringUtils.isNotEmpty((String)(proxy = url.getParameter("proxy")))) {
                    registryURL = registryURL.addParameter("proxy", proxy);
                }
                if (logger.isInfoEnabled()) {
                    if (url.getParameter("register", true)) {
                        logger.info("Register dubbo service " + this.interfaceClass.getName() + " url " + url + " to registry " + registryURL.getAddress());
                    } else {
                        logger.info("Export dubbo service " + this.interfaceClass.getName() + " to url " + url);
                    }
                }
                this.doExportUrl(registryURL.putAttribute("export", (Object)url), true, registerType);
            }
        } else {
            if (logger.isInfoEnabled()) {
                logger.info("Export dubbo service " + this.interfaceClass.getName() + " to url " + url);
            }
            this.doExportUrl(url, true, registerType);
        }
        return url;
    }

    private void doExportUrl(URL url, boolean withMetaData, RegisterTypeEnum registerType) {
        if (!url.getParameter("register", true)) {
            registerType = RegisterTypeEnum.MANUAL_REGISTER;
        }
        if (registerType == RegisterTypeEnum.NEVER_REGISTER || registerType == RegisterTypeEnum.MANUAL_REGISTER || registerType == RegisterTypeEnum.AUTO_REGISTER_BY_DEPLOYER) {
            url = url.addParameter("register", false);
        }
        DelegateProviderMetaDataInvoker invoker = this.proxyFactory.getInvoker(this.ref, this.interfaceClass, url);
        if (withMetaData) {
            invoker = new DelegateProviderMetaDataInvoker(invoker, this);
        }
        Exporter exporter = this.protocolSPI.export((Invoker)invoker);
        this.exporters.computeIfAbsent(registerType, k -> new CopyOnWriteArrayList()).add(exporter);
    }

    private void exportLocal(URL url) {
        ServiceConfigURL local = URLBuilder.from((URL)url).setProtocol("injvm").setHost("127.0.0.1").setPort(0).build();
        local = local.setScopeModel((ScopeModel)this.getScopeModel()).setServiceModel((ServiceModel)this.providerModel);
        local = local.addParameter("exporter.listener", "injvm");
        this.doExportUrl((URL)local, false, RegisterTypeEnum.AUTO_REGISTER);
        logger.info("Export dubbo service " + this.interfaceClass.getName() + " to local registry url : " + local);
    }

    private boolean isOnlyInJvm() {
        return this.getProtocols().size() == 1 && "injvm".equalsIgnoreCase(((ProtocolConfig)this.getProtocols().get(0)).getName());
    }

    private void postProcessConfig() {
        List configPostProcessors = this.getExtensionLoader(ConfigPostProcessor.class).getActivateExtension(URL.valueOf((String)"configPostProcessor://", (ScopeModel)this.getScopeModel()), (String[])null);
        configPostProcessors.forEach(component -> component.postProcessServiceConfig(this));
    }

    public void addServiceListener(ServiceListener listener) {
        this.serviceListeners.add(listener);
    }

    protected void onExported() {
        for (ServiceListener serviceListener : this.serviceListeners) {
            serviceListener.exported(this);
        }
    }

    protected void onUnexpoted() {
        for (ServiceListener serviceListener : this.serviceListeners) {
            serviceListener.unexported(this);
        }
    }

    private static String findConfiguredHosts(ProtocolConfig protocolConfig, ProviderConfig provider, Map<String, String> map) {
        boolean anyhost = false;
        String hostToBind = ServiceConfig.getValueFromConfig(protocolConfig, "DUBBO_IP_TO_BIND");
        if (StringUtils.isNotEmpty((String)hostToBind) && NetUtils.isInvalidLocalHost((String)hostToBind)) {
            throw new IllegalArgumentException("Specified invalid bind ip from property:DUBBO_IP_TO_BIND, value:" + hostToBind);
        }
        if (StringUtils.isEmpty((String)hostToBind)) {
            hostToBind = protocolConfig.getHost();
            if (provider != null && StringUtils.isEmpty((String)hostToBind)) {
                hostToBind = provider.getHost();
            }
            if (NetUtils.isInvalidLocalHost((String)hostToBind)) {
                anyhost = true;
                if (logger.isDebugEnabled()) {
                    logger.debug("No valid ip found from environment, try to get local host.");
                }
                hostToBind = NetUtils.getLocalHost();
            }
        }
        map.put("bind.ip", hostToBind);
        String hostToRegistry = ServiceConfig.getValueFromConfig(protocolConfig, "DUBBO_IP_TO_REGISTRY");
        if (StringUtils.isNotEmpty((String)hostToRegistry) && NetUtils.isInvalidLocalHost((String)hostToRegistry)) {
            throw new IllegalArgumentException("Specified invalid registry ip from property:DUBBO_IP_TO_REGISTRY, value:" + hostToRegistry);
        }
        if (StringUtils.isEmpty((String)hostToRegistry)) {
            hostToRegistry = hostToBind;
        }
        map.put("anyhost", String.valueOf(anyhost));
        return hostToRegistry;
    }

    private static synchronized Integer findConfiguredPort(ProtocolConfig protocolConfig, ProviderConfig provider, ExtensionLoader<Protocol> extensionLoader, String name, Map<String, String> map) {
        String port = ServiceConfig.getValueFromConfig(protocolConfig, "DUBBO_PORT_TO_BIND");
        Integer portToBind = ServiceConfig.parsePort(port);
        if (portToBind == null) {
            portToBind = protocolConfig.getPort();
            if (provider != null && (portToBind == null || portToBind == 0)) {
                portToBind = provider.getPort();
            }
            int defaultPort = ((Protocol)extensionLoader.getExtension(name)).getDefaultPort();
            if (portToBind == null || portToBind == 0) {
                portToBind = defaultPort;
            }
            if (portToBind <= 0 && ((portToBind = ServiceConfig.getRandomPort(name)) == null || portToBind < 0)) {
                portToBind = NetUtils.getAvailablePort((int)defaultPort);
                ServiceConfig.putRandomPort(name, portToBind);
            }
        }
        map.put("bind.port", String.valueOf(portToBind));
        String portToRegistryStr = ServiceConfig.getValueFromConfig(protocolConfig, "DUBBO_PORT_TO_REGISTRY");
        Integer portToRegistry = ServiceConfig.parsePort(portToRegistryStr);
        if (portToRegistry == null) {
            portToRegistry = portToBind;
        }
        return portToRegistry;
    }

    private static Integer parsePort(String configPort) {
        Integer port = null;
        if (StringUtils.isNotEmpty((String)configPort)) {
            try {
                int intPort = Integer.parseInt(configPort);
                if (NetUtils.isInvalidPort((int)intPort)) {
                    throw new IllegalArgumentException("Specified invalid port from env value:" + configPort);
                }
                port = intPort;
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Specified invalid port from env value:" + configPort);
            }
        }
        return port;
    }

    private static String getValueFromConfig(ProtocolConfig protocolConfig, String key) {
        String protocolPrefix = protocolConfig.getName().toUpperCase() + "_";
        String value = ConfigUtils.getSystemProperty((String)(protocolPrefix + key));
        if (StringUtils.isEmpty((String)value)) {
            value = ConfigUtils.getSystemProperty((String)key);
        }
        return value;
    }

    private static Integer getRandomPort(String protocol) {
        protocol = protocol.toLowerCase();
        return RANDOM_PORT_MAP.getOrDefault(protocol, Integer.MIN_VALUE);
    }

    private static void putRandomPort(String protocol, Integer port) {
        if (!RANDOM_PORT_MAP.containsKey(protocol = protocol.toLowerCase())) {
            RANDOM_PORT_MAP.put(protocol, port);
            logger.warn("5-8", "", "", "Use random available port(" + port + ") for protocol " + protocol);
        }
    }

    @Transient
    public Runnable getDestroyRunner() {
        return this::unexport;
    }
}

