/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config;

import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.dubbo.common.config.ConfigurationUtils;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.Assert;
import org.apache.dubbo.rpc.GracefulShutdown;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.model.ModuleModel;
import org.apache.dubbo.rpc.model.ScopeModel;

public class DubboShutdownHook
extends Thread {
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(DubboShutdownHook.class);
    private final ApplicationModel applicationModel;
    private final AtomicBoolean registered = new AtomicBoolean(false);
    private final AtomicBoolean destroyed = new AtomicBoolean(false);
    private final boolean ignoreListenShutdownHook;

    public DubboShutdownHook(ApplicationModel applicationModel) {
        super("DubboShutdownHook");
        this.applicationModel = applicationModel;
        Assert.notNull((Object)this.applicationModel, (String)"ApplicationModel is null");
        this.ignoreListenShutdownHook = Boolean.parseBoolean(ConfigurationUtils.getProperty((ScopeModel)applicationModel, (String)"dubbo.shutdownHook.listenIgnore"));
        if (this.ignoreListenShutdownHook) {
            logger.info("dubbo.shutdownHook.listenIgnore configured, will ignore add shutdown hook to jvm.");
        }
    }

    @Override
    public void run() {
        if (!this.ignoreListenShutdownHook && this.destroyed.compareAndSet(false, true)) {
            if (logger.isInfoEnabled()) {
                logger.info("Run shutdown hook now.");
            }
            this.doDestroy();
        }
    }

    private void doDestroy() {
        int timeout;
        List gracefulShutdowns = GracefulShutdown.getGracefulShutdowns((FrameworkModel)this.applicationModel.getFrameworkModel());
        for (Object gracefulShutdown : gracefulShutdowns) {
            gracefulShutdown.readonly();
        }
        boolean hasModuleBindSpring = false;
        for (ModuleModel module : this.applicationModel.getModuleModels()) {
            if (!module.isLifeCycleManagedExternally()) continue;
            hasModuleBindSpring = true;
            break;
        }
        if (hasModuleBindSpring && (timeout = ConfigurationUtils.getServerShutdownTimeout((ScopeModel)this.applicationModel)) > 0) {
            long start = System.currentTimeMillis();
            logger.info("Waiting for modules(" + this.applicationModel.getDesc() + ") managed by Spring to be shutdown.");
            while (!this.applicationModel.isDestroyed() && hasModuleBindSpring && System.currentTimeMillis() - start < (long)timeout) {
                try {
                    TimeUnit.MILLISECONDS.sleep(10L);
                    hasModuleBindSpring = false;
                    if (this.applicationModel.isDestroyed()) continue;
                    for (ModuleModel module : this.applicationModel.getModuleModels()) {
                        if (!module.isLifeCycleManagedExternally()) continue;
                        hasModuleBindSpring = true;
                    }
                }
                catch (InterruptedException e) {
                    logger.warn("99-1", "", "", e.getMessage(), (Throwable)e);
                    Thread.currentThread().interrupt();
                }
            }
            if (!this.applicationModel.isDestroyed()) {
                long usage = System.currentTimeMillis() - start;
                logger.info("Dubbo wait for application(" + this.applicationModel.getDesc() + ") managed by Spring to be shutdown failed, time usage: " + usage + "ms");
            }
        }
        if (!this.applicationModel.isDestroyed()) {
            logger.info("Dubbo shutdown hooks execute now. " + this.applicationModel.getDesc());
            this.applicationModel.destroy();
        }
    }

    public void register() {
        if (!this.ignoreListenShutdownHook && this.registered.compareAndSet(false, true)) {
            try {
                Runtime.getRuntime().addShutdownHook(this);
            }
            catch (IllegalStateException e) {
                logger.warn("5-2", "", "", "register shutdown hook failed: " + e.getMessage(), (Throwable)e);
            }
            catch (Exception e) {
                logger.warn("5-2", "", "", "register shutdown hook failed: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public void unregister() {
        if (!this.ignoreListenShutdownHook && this.registered.compareAndSet(true, false)) {
            if (this.isAlive()) {
                return;
            }
            try {
                Runtime.getRuntime().removeShutdownHook(this);
            }
            catch (IllegalStateException e) {
                logger.warn("5-2", "", "", "unregister shutdown hook failed: " + e.getMessage(), (Throwable)e);
            }
            catch (Exception e) {
                logger.warn("5-2", "", "", "unregister shutdown hook failed: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public boolean getRegistered() {
        return this.registered.get();
    }
}

