/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.dubbo.common.BaseServiceMetadata;
import org.apache.dubbo.common.config.ReferenceCache;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.ConcurrentHashMapUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.config.ReferenceConfigBase;
import org.apache.dubbo.rpc.service.Destroyable;

public class SimpleReferenceCache
implements ReferenceCache {
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(SimpleReferenceCache.class);
    public static final String DEFAULT_NAME = "_DEFAULT_";
    public static final KeyGenerator DEFAULT_KEY_GENERATOR = referenceConfig -> {
        String iName = referenceConfig.getInterface();
        if (StringUtils.isBlank((CharSequence)iName)) {
            Class clazz = referenceConfig.getInterfaceClass();
            iName = clazz.getName();
        }
        if (StringUtils.isBlank((CharSequence)iName)) {
            throw new IllegalArgumentException("No interface info in ReferenceConfig" + referenceConfig);
        }
        return BaseServiceMetadata.buildServiceKey((String)iName, (String)referenceConfig.getGroup(), (String)referenceConfig.getVersion());
    };
    private static final AtomicInteger nameIndex = new AtomicInteger();
    static final ConcurrentMap<String, SimpleReferenceCache> CACHE_HOLDER = new ConcurrentHashMap<String, SimpleReferenceCache>();
    private final String name;
    private final KeyGenerator generator;
    private final ConcurrentMap<String, List<ReferenceConfigBase<?>>> referenceKeyMap = new ConcurrentHashMap();
    private final ConcurrentMap<Class<?>, List<ReferenceConfigBase<?>>> referenceTypeMap = new ConcurrentHashMap();
    private final Map<ReferenceConfigBase<?>, Object> references = new ConcurrentHashMap();

    protected SimpleReferenceCache(String name, KeyGenerator generator) {
        this.name = name;
        this.generator = generator;
    }

    public static SimpleReferenceCache getCache() {
        return SimpleReferenceCache.getCache(DEFAULT_NAME);
    }

    public static SimpleReferenceCache newCache() {
        return SimpleReferenceCache.getCache("_DEFAULT_#" + nameIndex.incrementAndGet());
    }

    public static SimpleReferenceCache getCache(String name) {
        return SimpleReferenceCache.getCache(name, DEFAULT_KEY_GENERATOR);
    }

    public static SimpleReferenceCache getCache(String name, KeyGenerator keyGenerator) {
        return (SimpleReferenceCache)ConcurrentHashMapUtils.computeIfAbsent(CACHE_HOLDER, (Object)name, k -> new SimpleReferenceCache((String)k, keyGenerator));
    }

    public <T> T get(ReferenceConfigBase<T> rc) {
        String key = this.generator.generateKey(rc);
        Class type = rc.getInterfaceClass();
        boolean singleton = rc.getSingleton() == null || rc.getSingleton() != false;
        Object proxy = null;
        if (singleton) {
            proxy = this.get(key, type);
        } else {
            logger.warn("5-27", "", "", "Using non-singleton ReferenceConfig and ReferenceCache at the same time may cause memory leak. Call ReferenceConfig#get() directly for non-singleton ReferenceConfig instead of using ReferenceCache#get(ReferenceConfig)");
        }
        if (proxy == null) {
            List referencesOfType = (List)ConcurrentHashMapUtils.computeIfAbsent(this.referenceTypeMap, (Object)type, _t -> Collections.synchronizedList(new ArrayList()));
            referencesOfType.add(rc);
            List referenceConfigList = (List)ConcurrentHashMapUtils.computeIfAbsent(this.referenceKeyMap, (Object)key, _k -> Collections.synchronizedList(new ArrayList()));
            referenceConfigList.add(rc);
            proxy = rc.get();
        }
        return (T)proxy;
    }

    public <T> T get(String key, Class<T> type) {
        List referenceConfigs = (List)this.referenceKeyMap.get(key);
        if (CollectionUtils.isNotEmpty((Collection)referenceConfigs)) {
            return (T)((ReferenceConfigBase)referenceConfigs.get(0)).get();
        }
        return null;
    }

    public <T> T get(String key) {
        List referenceConfigBases = (List)this.referenceKeyMap.get(key);
        if (CollectionUtils.isNotEmpty((Collection)referenceConfigBases)) {
            return (T)((ReferenceConfigBase)referenceConfigBases.get(0)).get();
        }
        return null;
    }

    public <T> List<T> getAll(Class<T> type) {
        List referenceConfigBases = (List)this.referenceTypeMap.get(type);
        if (CollectionUtils.isEmpty((Collection)referenceConfigBases)) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Object> proxiesOfType = new ArrayList<Object>(referenceConfigBases.size());
        for (ReferenceConfigBase rc : referenceConfigBases) {
            proxiesOfType.add(rc.get());
        }
        return Collections.unmodifiableList(proxiesOfType);
    }

    public <T> T get(Class<T> type) {
        List referenceConfigBases = (List)this.referenceTypeMap.get(type);
        if (CollectionUtils.isNotEmpty((Collection)referenceConfigBases)) {
            return (T)((ReferenceConfigBase)referenceConfigBases.get(0)).get();
        }
        return null;
    }

    public void destroy(String key, Class<?> type) {
        List referencesOfKey = (List)this.referenceKeyMap.remove(key);
        if (CollectionUtils.isEmpty((Collection)referencesOfKey)) {
            return;
        }
        List referencesOfType = (List)this.referenceTypeMap.get(type);
        if (CollectionUtils.isEmpty((Collection)referencesOfType)) {
            return;
        }
        for (ReferenceConfigBase rc : referencesOfKey) {
            referencesOfType.remove(rc);
            this.destroyReference(rc);
        }
    }

    public void destroy(Class<?> type) {
        List referencesOfType = (List)this.referenceTypeMap.remove(type);
        for (ReferenceConfigBase rc : referencesOfType) {
            String key = this.generator.generateKey(rc);
            this.referenceKeyMap.remove(key);
            this.destroyReference(rc);
        }
    }

    public <T> void destroy(ReferenceConfigBase<T> referenceConfig) {
        String key = this.generator.generateKey(referenceConfig);
        Class type = referenceConfig.getInterfaceClass();
        this.destroy(key, type);
    }

    public void destroyAll() {
        if (CollectionUtils.isEmptyMap(this.referenceKeyMap)) {
            return;
        }
        this.referenceKeyMap.forEach((_k, referencesOfKey) -> {
            for (ReferenceConfigBase rc : referencesOfKey) {
                this.destroyReference(rc);
            }
        });
        this.referenceKeyMap.clear();
        this.referenceTypeMap.clear();
    }

    private void destroyReference(ReferenceConfigBase<?> rc) {
        Destroyable proxy = (Destroyable)rc.get();
        if (proxy != null) {
            proxy.$destroy();
        }
        rc.destroy();
    }

    public Map<String, List<ReferenceConfigBase<?>>> getReferenceMap() {
        return this.referenceKeyMap;
    }

    public Map<Class<?>, List<ReferenceConfigBase<?>>> getReferenceTypeMap() {
        return this.referenceTypeMap;
    }

    public String toString() {
        return "ReferenceCache(name: " + this.name + ")";
    }

    public static interface KeyGenerator {
        public String generateKey(ReferenceConfigBase<?> var1);
    }
}

