/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.spring.beans.factory.annotation;

import com.alibaba.spring.beans.factory.annotation.AbstractAnnotationBeanPostProcessor;
import com.alibaba.spring.util.AnnotationUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.Reference;
import org.apache.dubbo.config.spring.ReferenceBean;
import org.apache.dubbo.config.spring.ServiceBean;
import org.apache.dubbo.config.spring.beans.factory.annotation.ReferenceBeanBuilder;
import org.apache.dubbo.config.spring.beans.factory.annotation.ServiceBeanNameBuilder;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.InjectionMetadata;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.env.PropertyResolver;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class ReferenceAnnotationBeanPostProcessor
extends AbstractAnnotationBeanPostProcessor
implements ApplicationContextAware,
ApplicationListener {
    private static final Logger logger = LoggerFactory.getLogger(ReferenceAnnotationBeanPostProcessor.class);
    public static final String BEAN_NAME = "referenceAnnotationBeanPostProcessor";
    private static final int CACHE_SIZE = Integer.getInteger("referenceAnnotationBeanPostProcessor.cache.size", 32);
    private final ConcurrentMap<String, ReferenceBean<?>> referenceBeanCache = new ConcurrentHashMap(CACHE_SIZE);
    private final ConcurrentMap<InjectionMetadata.InjectedElement, ReferenceBean<?>> injectedFieldReferenceBeanCache = new ConcurrentHashMap(CACHE_SIZE);
    private final ConcurrentMap<InjectionMetadata.InjectedElement, ReferenceBean<?>> injectedMethodReferenceBeanCache = new ConcurrentHashMap(CACHE_SIZE);
    private ApplicationContext applicationContext;
    private static Map<String, TreeSet<String>> referencedBeanNameIdx = new HashMap<String, TreeSet<String>>();

    public ReferenceAnnotationBeanPostProcessor() {
        super(new Class[]{DubboReference.class, Reference.class, com.alibaba.dubbo.config.annotation.Reference.class});
    }

    public Collection<ReferenceBean<?>> getReferenceBeans() {
        return this.referenceBeanCache.values();
    }

    public Map<InjectionMetadata.InjectedElement, ReferenceBean<?>> getInjectedFieldReferenceBeanMap() {
        return Collections.unmodifiableMap(this.injectedFieldReferenceBeanCache);
    }

    public Map<InjectionMetadata.InjectedElement, ReferenceBean<?>> getInjectedMethodReferenceBeanMap() {
        return Collections.unmodifiableMap(this.injectedMethodReferenceBeanCache);
    }

    protected Object doGetInjectedBean(AnnotationAttributes attributes, Object bean, String beanName, Class<?> injectedType, InjectionMetadata.InjectedElement injectedElement) throws Exception {
        String referencedBeanName = this.buildReferencedBeanName(attributes, injectedType);
        String referenceBeanName = this.getReferenceBeanName(attributes, injectedType);
        referencedBeanNameIdx.computeIfAbsent(referencedBeanName, k -> new TreeSet()).add(referenceBeanName);
        ReferenceBean referenceBean = this.buildReferenceBeanIfAbsent(referenceBeanName, attributes, injectedType);
        boolean localServiceBean = this.isLocalServiceBean(referencedBeanName, referenceBean, attributes);
        this.prepareReferenceBean(referencedBeanName, referenceBean, localServiceBean);
        this.registerReferenceBean(referencedBeanName, referenceBean, attributes, localServiceBean, injectedType);
        this.cacheInjectedReferenceBean(referenceBean, injectedElement);
        return referenceBean.get();
    }

    private void registerReferenceBean(String referencedBeanName, ReferenceBean referenceBean, AnnotationAttributes attributes, boolean localServiceBean, Class<?> interfaceClass) {
        ConfigurableListableBeanFactory beanFactory = this.getBeanFactory();
        String beanName = this.getReferenceBeanName(attributes, interfaceClass);
        if (localServiceBean) {
            AbstractBeanDefinition beanDefinition = (AbstractBeanDefinition)beanFactory.getBeanDefinition(referencedBeanName);
            RuntimeBeanReference runtimeBeanReference = (RuntimeBeanReference)beanDefinition.getPropertyValues().get("ref");
            String serviceBeanName = runtimeBeanReference.getBeanName();
            beanFactory.registerAlias(serviceBeanName, beanName);
        } else if (!beanFactory.containsBean(beanName)) {
            beanFactory.registerSingleton(beanName, (Object)referenceBean);
        }
    }

    private String getReferenceBeanName(AnnotationAttributes attributes, Class<?> interfaceClass) {
        String beanName = (String)AnnotationUtils.getAttribute((Map)attributes, (String)"id");
        if (!StringUtils.hasText((String)beanName)) {
            beanName = this.generateReferenceBeanName(attributes, interfaceClass);
        }
        return beanName;
    }

    private String generateReferenceBeanName(AnnotationAttributes attributes, Class<?> interfaceClass) {
        StringBuilder beanNameBuilder = new StringBuilder("@Reference");
        if (!attributes.isEmpty()) {
            beanNameBuilder.append('(');
            for (Map.Entry entry : attributes.entrySet()) {
                String value;
                if ("parameters".equals(entry.getKey())) {
                    ArrayList<String> pairs = this.getParameterPairs(entry);
                    value = this.convertAttribute(pairs.stream().sorted().toArray());
                } else {
                    value = this.convertAttribute(entry.getValue());
                }
                beanNameBuilder.append((String)entry.getKey()).append('=').append(value).append(',');
            }
            beanNameBuilder.setCharAt(beanNameBuilder.lastIndexOf(","), ')');
        }
        beanNameBuilder.append(" ").append(interfaceClass.getName());
        return beanNameBuilder.toString();
    }

    private ArrayList<String> getParameterPairs(Map.Entry<String, Object> entry) {
        String[] entryValues = (String[])entry.getValue();
        ArrayList<String> pairs = new ArrayList<String>();
        for (int i = 0; i < entryValues.length / 2 * 2; i += 2) {
            pairs.add(entryValues[i] + "=" + entryValues[i + 1]);
        }
        return pairs;
    }

    private String convertAttribute(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Annotation) {
            AnnotationAttributes attributes = AnnotationUtils.getAnnotationAttributes((Annotation)((Annotation)obj), (boolean)true, (String[])new String[0]);
            for (Map.Entry entry : attributes.entrySet()) {
                entry.setValue(this.convertAttribute(entry.getValue()));
            }
            return String.valueOf(attributes);
        }
        if (obj.getClass().isArray()) {
            Object[] array = ObjectUtils.toObjectArray((Object)obj);
            String[] newArray = new String[array.length];
            for (int i = 0; i < array.length; ++i) {
                newArray[i] = this.convertAttribute(array[i]);
            }
            return Arrays.toString(Arrays.stream(newArray).sorted().toArray());
        }
        return String.valueOf(obj);
    }

    private boolean isLocalServiceBean(String referencedBeanName, ReferenceBean referenceBean, AnnotationAttributes attributes) {
        return this.existsServiceBean(referencedBeanName) && !this.isRemoteReferenceBean(referenceBean, attributes);
    }

    private boolean existsServiceBean(String referencedBeanName) {
        return this.applicationContext.containsBean(referencedBeanName) && this.applicationContext.isTypeMatch(referencedBeanName, ServiceBean.class);
    }

    private boolean isRemoteReferenceBean(ReferenceBean referenceBean, AnnotationAttributes attributes) {
        boolean remote = Boolean.FALSE.equals(referenceBean.isInjvm()) || Boolean.FALSE.equals(attributes.get((Object)"injvm"));
        return remote;
    }

    private void prepareReferenceBean(String referencedBeanName, ReferenceBean referenceBean, boolean localServiceBean) {
        if (localServiceBean) {
            referenceBean.setInjvm(Boolean.TRUE);
            this.exportServiceBeanIfNecessary(referencedBeanName);
        }
    }

    private void exportServiceBeanIfNecessary(String referencedBeanName) {
        ServiceBean serviceBean;
        if (this.existsServiceBean(referencedBeanName) && !(serviceBean = this.getServiceBean(referencedBeanName)).isExported()) {
            serviceBean.export();
        }
    }

    private ServiceBean getServiceBean(String referencedBeanName) {
        return (ServiceBean)((Object)this.applicationContext.getBean(referencedBeanName, ServiceBean.class));
    }

    protected String buildInjectedObjectCacheKey(AnnotationAttributes attributes, Object bean, String beanName, Class<?> injectedType, InjectionMetadata.InjectedElement injectedElement) {
        return this.buildReferencedBeanName(attributes, injectedType) + "#source=" + injectedElement.getMember() + "#attributes=" + AnnotationUtils.getAttributes((Map)attributes, (PropertyResolver)this.getEnvironment(), (String[])new String[0]);
    }

    private String buildReferencedBeanName(AnnotationAttributes attributes, Class<?> serviceInterfaceType) {
        ServiceBeanNameBuilder serviceBeanNameBuilder = ServiceBeanNameBuilder.create(attributes, serviceInterfaceType, this.getEnvironment());
        return serviceBeanNameBuilder.build();
    }

    private ReferenceBean buildReferenceBeanIfAbsent(String referenceBeanName, AnnotationAttributes attributes, Class<?> referencedType) throws Exception {
        ReferenceBean referenceBean = (ReferenceBean)((Object)this.referenceBeanCache.get(referenceBeanName));
        if (referenceBean == null) {
            ReferenceBeanBuilder beanBuilder = (ReferenceBeanBuilder)ReferenceBeanBuilder.create(attributes, this.applicationContext).interfaceClass(referencedType);
            referenceBean = (ReferenceBean)((Object)beanBuilder.build());
            this.referenceBeanCache.put(referenceBeanName, referenceBean);
        } else if (!referencedType.isAssignableFrom(referenceBean.getInterfaceClass())) {
            throw new IllegalArgumentException("reference bean name " + referenceBeanName + " has been duplicated, but interfaceClass " + referenceBean.getInterfaceClass().getName() + " cannot be assigned to " + referencedType.getName());
        }
        return referenceBean;
    }

    private void cacheInjectedReferenceBean(ReferenceBean referenceBean, InjectionMetadata.InjectedElement injectedElement) {
        if (injectedElement.getMember() instanceof Field) {
            this.injectedFieldReferenceBeanCache.put(injectedElement, referenceBean);
        } else if (injectedElement.getMember() instanceof Method) {
            this.injectedMethodReferenceBeanCache.put(injectedElement, referenceBean);
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void destroy() throws Exception {
        super.destroy();
        this.referenceBeanCache.clear();
        this.injectedFieldReferenceBeanCache.clear();
        this.injectedMethodReferenceBeanCache.clear();
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ContextRefreshedEvent) {
            referencedBeanNameIdx.entrySet().stream().filter(e -> ((TreeSet)e.getValue()).size() > 1).forEach(e -> {
                String logPrefix = (String)e.getKey() + " has " + ((TreeSet)e.getValue()).size() + " reference instances, there are: ";
                logger.warn(((TreeSet)e.getValue()).stream().collect(Collectors.joining(", ", logPrefix, "")));
            });
            referencedBeanNameIdx.clear();
        }
    }
}

