/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.spring.beans.factory.annotation;

import com.alibaba.spring.util.AnnotationUtils;
import com.alibaba.spring.util.ObjectUtils;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.config.ConsumerConfig;
import org.apache.dubbo.config.MethodConfig;
import org.apache.dubbo.config.annotation.Method;
import org.apache.dubbo.config.annotation.Reference;
import org.apache.dubbo.config.spring.ReferenceBean;
import org.apache.dubbo.config.spring.beans.factory.annotation.AnnotatedInterfaceConfigBeanBuilder;
import org.apache.dubbo.config.spring.beans.factory.annotation.AnnotationPropertyValuesAdapter;
import org.apache.dubbo.config.spring.util.DubboAnnotationUtils;
import org.apache.dubbo.config.spring.util.DubboBeanUtils;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.propertyeditors.StringTrimmerEditor;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.env.PropertyResolver;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.validation.DataBinder;

class ReferenceBeanBuilder
extends AnnotatedInterfaceConfigBeanBuilder<ReferenceBean> {
    static final String[] IGNORE_FIELD_NAMES = (String[])ObjectUtils.of((Object[])new String[]{"application", "module", "consumer", "monitor", "registry"});

    private ReferenceBeanBuilder(AnnotationAttributes attributes, ApplicationContext applicationContext) {
        super(attributes, applicationContext);
    }

    private void configureInterface(AnnotationAttributes attributes, ReferenceBean referenceBean) {
        Boolean generic = (Boolean)AnnotationUtils.getAttribute((Map)attributes, (String)"generic");
        if (generic != null && generic.booleanValue()) {
            String interfaceClassName = (String)AnnotationUtils.getAttribute((Map)attributes, (String)"interfaceName");
            Assert.hasText((String)interfaceClassName, (String)"@Reference interfaceName() must be present when reference a generic service!");
            referenceBean.setInterface(interfaceClassName);
            return;
        }
        Class<?> serviceInterfaceClass = DubboAnnotationUtils.resolveServiceInterfaceClass(attributes, this.interfaceClass);
        Assert.isTrue((boolean)serviceInterfaceClass.isInterface(), (String)"The class of field or method that was annotated @Reference is not an interface!");
        referenceBean.setInterface(serviceInterfaceClass);
    }

    private void configureConsumerConfig(AnnotationAttributes attributes, ReferenceBean<?> referenceBean) {
        String consumerBeanName = (String)AnnotationUtils.getAttribute((Map)attributes, (String)"consumer");
        ConsumerConfig consumerConfig = DubboBeanUtils.getOptionalBean((ListableBeanFactory)this.applicationContext, consumerBeanName, ConsumerConfig.class);
        referenceBean.setConsumer(consumerConfig);
    }

    void configureMethodConfig(AnnotationAttributes attributes, ReferenceBean<?> referenceBean) {
        Method[] methods = (Method[])attributes.get((Object)"methods");
        List methodConfigs = MethodConfig.constructMethodConfig((Method[])methods);
        if (!methodConfigs.isEmpty()) {
            referenceBean.setMethods(methodConfigs);
        }
    }

    @Override
    protected ReferenceBean doBuild() {
        return new ReferenceBean();
    }

    @Override
    protected void preConfigureBean(AnnotationAttributes attributes, ReferenceBean referenceBean) {
        Assert.notNull((Object)this.interfaceClass, (String)"The interface class must set first!");
        DataBinder dataBinder = new DataBinder((Object)referenceBean);
        dataBinder.registerCustomEditor(String.class, "filter", (PropertyEditor)new StringTrimmerEditor(true));
        dataBinder.registerCustomEditor(String.class, "listener", (PropertyEditor)new StringTrimmerEditor(true));
        dataBinder.registerCustomEditor(Map.class, "parameters", (PropertyEditor)new PropertyEditorSupport(){

            @Override
            public void setAsText(String text) throws IllegalArgumentException {
                String content = StringUtils.trimAllWhitespace((String)text);
                if (!StringUtils.hasText((String)content)) {
                    return;
                }
                content = StringUtils.replace((String)content, (String)"=", (String)",");
                content = StringUtils.replace((String)content, (String)":", (String)",");
                Map parameters = CollectionUtils.toStringMap((String[])StringUtils.commaDelimitedListToStringArray((String)content));
                this.setValue(parameters);
            }
        });
        dataBinder.bind((PropertyValues)new AnnotationPropertyValuesAdapter((Map<String, Object>)attributes, (PropertyResolver)this.applicationContext.getEnvironment(), IGNORE_FIELD_NAMES));
    }

    @Override
    protected String resolveModuleConfigBeanName(AnnotationAttributes attributes) {
        return (String)AnnotationUtils.getAttribute((Map)attributes, (String)"module");
    }

    @Override
    protected String resolveApplicationConfigBeanName(AnnotationAttributes attributes) {
        return (String)AnnotationUtils.getAttribute((Map)attributes, (String)"application");
    }

    @Override
    protected String[] resolveRegistryConfigBeanNames(AnnotationAttributes attributes) {
        return (String[])AnnotationUtils.getAttribute((Map)attributes, (String)"registry");
    }

    @Override
    protected String resolveMonitorConfigBeanName(AnnotationAttributes attributes) {
        return (String)AnnotationUtils.getAttribute((Map)attributes, (String)"monitor");
    }

    @Override
    protected void postConfigureBean(AnnotationAttributes attributes, ReferenceBean bean) throws Exception {
        bean.setApplicationContext(this.applicationContext);
        this.configureInterface(attributes, bean);
        this.configureConsumerConfig(attributes, bean);
        this.configureMethodConfig(attributes, bean);
        bean.afterPropertiesSet();
    }

    @Deprecated
    public static ReferenceBeanBuilder create(Reference reference, ClassLoader classLoader, ApplicationContext applicationContext) {
        return ReferenceBeanBuilder.create(AnnotationAttributes.fromMap((Map)AnnotationUtils.getAttributes((Annotation)reference, (PropertyResolver)applicationContext.getEnvironment(), (boolean)true, (String[])new String[0])), applicationContext);
    }

    public static ReferenceBeanBuilder create(AnnotationAttributes attributes, ApplicationContext applicationContext) {
        return new ReferenceBeanBuilder(attributes, applicationContext);
    }
}

