/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.spring.beans.factory.config;

import com.alibaba.spring.beans.factory.config.GenericBeanPostProcessorAdapter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.dubbo.config.AbstractConfig;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.annotation.CommonAnnotationBeanPostProcessor;
import org.springframework.core.PriorityOrdered;

public class DubboConfigEarlyInitializationPostProcessor
extends GenericBeanPostProcessorAdapter<AbstractConfig>
implements BeanDefinitionRegistryPostProcessor,
PriorityOrdered {
    private static final Log logger = LogFactory.getLog((String)DubboConfigEarlyInitializationPostProcessor.class.getName());
    public static final String BEAN_NAME = "dubboConfigEarlyInitializationPostProcessor";
    private DefaultListableBeanFactory beanFactory;

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
        this.beanFactory = this.unwrap(registry);
        this.initBeanFactory();
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        if (beanFactory == null) {
            this.beanFactory = this.unwrap(beanFactory);
            this.initBeanFactory();
        }
    }

    protected void processBeforeInitialization(AbstractConfig config, String beanName) throws BeansException {
        if (this.beanFactory == null) {
            if (logger.isErrorEnabled()) {
                logger.error((Object)"Current Processor is not running in Spring container, next action will be skipped!");
            }
            return;
        }
        if (!this.hasRegisteredCommonAnnotationBeanPostProcessor()) {
            if (logger.isWarnEnabled()) {
                logger.warn((Object)"CommonAnnotationBeanPostProcessor is not registered yet, the method addIntoConfigManager() will be invoked directly");
            }
            config.addIntoConfigManager();
        }
    }

    private DefaultListableBeanFactory unwrap(Object registry) {
        if (registry instanceof DefaultListableBeanFactory) {
            return (DefaultListableBeanFactory)registry;
        }
        return null;
    }

    private void initBeanFactory() {
        if (this.beanFactory != null) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)"BeanFactory is about to be initialized, trying to resolve the Dubbo Config Beans early initialization");
            }
            this.beanFactory.addBeanPostProcessor((BeanPostProcessor)this);
        }
    }

    private boolean hasRegisteredCommonAnnotationBeanPostProcessor() {
        for (BeanPostProcessor beanPostProcessor : this.beanFactory.getBeanPostProcessors()) {
            if (!CommonAnnotationBeanPostProcessor.class.equals(beanPostProcessor.getClass())) continue;
            return true;
        }
        return false;
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }
}

