/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.spring.reference;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.dubbo.common.utils.Assert;
import org.apache.dubbo.config.ReferenceConfig;
import org.apache.dubbo.config.bootstrap.DubboBootstrap;
import org.apache.dubbo.config.spring.ReferenceBean;
import org.apache.dubbo.config.spring.reference.ReferenceBeanSupport;
import org.apache.dubbo.config.spring.reference.ReferenceCreator;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertyResolver;

public class ReferenceBeanManager
implements ApplicationContextAware {
    public static final String BEAN_NAME = "dubboReferenceBeanManager";
    private final Log logger = LogFactory.getLog(this.getClass());
    private Map<String, ReferenceBean> referenceIdMap = new ConcurrentHashMap<String, ReferenceBean>();
    private Map<String, List<String>> referenceKeyMap = new ConcurrentHashMap<String, List<String>>();
    private Map<String, ReferenceConfig> referenceConfigMap = new ConcurrentHashMap<String, ReferenceConfig>();
    private ApplicationContext applicationContext;
    private volatile boolean initialized = false;

    public void addReference(ReferenceBean referenceBean) throws Exception {
        String referenceBeanName = referenceBean.getId();
        Assert.notEmptyString((String)referenceBeanName, (String)"The id of ReferenceBean cannot be empty");
        Environment propertyResolver = this.applicationContext.getEnvironment();
        if (!this.initialized) {
            this.logger.warn((Object)("Early initialize reference bean before DubboConfigInitializationPostProcessor, the BeanPostProcessor has not been loaded at this time, which may cause abnormalities in some components (such as seata): " + referenceBeanName + " = " + ReferenceBeanSupport.generateReferenceKey(referenceBean, (PropertyResolver)propertyResolver)));
        }
        String referenceKey = ReferenceBeanSupport.generateReferenceKey(referenceBean, (PropertyResolver)propertyResolver);
        ReferenceBean oldReferenceBean = this.referenceIdMap.get(referenceBeanName);
        if (oldReferenceBean != null) {
            if (referenceBean != oldReferenceBean) {
                String oldReferenceKey = ReferenceBeanSupport.generateReferenceKey(oldReferenceBean, (PropertyResolver)propertyResolver);
                throw new IllegalStateException("Found duplicated ReferenceBean with id: " + referenceBeanName + ", old: " + oldReferenceKey + ", new: " + referenceKey);
            }
            return;
        }
        this.referenceIdMap.put(referenceBeanName, referenceBean);
        this.registerReferenceKeyAndBeanName(referenceKey, referenceBeanName);
        if (this.initialized) {
            this.initReferenceBean(referenceBean);
        }
    }

    public void registerReferenceKeyAndBeanName(String referenceKey, String referenceBeanName) {
        ((List)this.referenceKeyMap.getOrDefault(referenceKey, new ArrayList())).add(referenceBeanName);
    }

    public ReferenceBean getById(String key) {
        return this.referenceIdMap.get(key);
    }

    public List<String> getByKey(String key) {
        return Collections.unmodifiableList(this.referenceKeyMap.getOrDefault(key, new ArrayList()));
    }

    public Collection<ReferenceBean> getReferences() {
        return this.referenceIdMap.values();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void prepareReferenceBeans() throws Exception {
        this.initialized = true;
        for (ReferenceBean referenceBean : this.getReferences()) {
            this.initReferenceBean(referenceBean);
        }
    }

    private synchronized void initReferenceBean(ReferenceBean referenceBean) throws Exception {
        if (referenceBean.getReferenceConfig() != null) {
            return;
        }
        String referenceKey = ReferenceBeanSupport.generateReferenceKey(referenceBean, (PropertyResolver)this.applicationContext.getEnvironment());
        ReferenceConfig referenceConfig = this.referenceConfigMap.get(referenceKey);
        if (referenceConfig == null) {
            Map<String, Object> referenceAttributes = ReferenceBeanSupport.getReferenceAttributes(referenceBean);
            referenceConfig = ReferenceCreator.create(referenceAttributes, this.applicationContext).defaultInterfaceClass(referenceBean.getObjectType()).build();
            if (referenceBean.getId() != null && !referenceBean.getId().contains("#")) {
                referenceConfig.setId(referenceBean.getId());
            }
            this.referenceConfigMap.put(referenceKey, referenceConfig);
            DubboBootstrap.getInstance().reference(referenceConfig);
        }
        referenceBean.setKeyAndReferenceConfig(referenceKey, referenceConfig);
    }
}

