/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.spring.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.dubbo.config.spring.beans.factory.annotation.DubboConfigAliasPostProcessor;
import org.apache.dubbo.config.spring.beans.factory.annotation.ReferenceAnnotationBeanPostProcessor;
import org.apache.dubbo.config.spring.beans.factory.annotation.ServicePackagesHolder;
import org.apache.dubbo.config.spring.beans.factory.config.DubboConfigDefaultPropertyValueBeanPostProcessor;
import org.apache.dubbo.config.spring.context.DubboBootstrapApplicationListener;
import org.apache.dubbo.config.spring.context.DubboConfigInitializationPostProcessor;
import org.apache.dubbo.config.spring.context.DubboInfraBeanRegisterPostProcessor;
import org.apache.dubbo.config.spring.reference.ReferenceBeanManager;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;

public interface DubboBeanUtils {
    public static final Log log = LogFactory.getLog(DubboBeanUtils.class);

    public static void registerCommonBeans(BeanDefinitionRegistry registry) {
        DubboBeanUtils.registerInfrastructureBean(registry, "dubboServicePackagesHolder", ServicePackagesHolder.class);
        DubboBeanUtils.registerInfrastructureBean(registry, "dubboReferenceBeanManager", ReferenceBeanManager.class);
        DubboBeanUtils.registerInfrastructureBean(registry, "referenceAnnotationBeanPostProcessor", ReferenceAnnotationBeanPostProcessor.class);
        DubboBeanUtils.registerInfrastructureBean(registry, "dubboConfigAliasPostProcessor", DubboConfigAliasPostProcessor.class);
        DubboBeanUtils.registerInfrastructureBean(registry, "dubboBootstrapApplicationListener", DubboBootstrapApplicationListener.class);
        DubboBeanUtils.registerInfrastructureBean(registry, "dubboConfigDefaultPropertyValueBeanPostProcessor", DubboConfigDefaultPropertyValueBeanPostProcessor.class);
        DubboBeanUtils.registerInfrastructureBean(registry, DubboConfigInitializationPostProcessor.BEAN_NAME, DubboConfigInitializationPostProcessor.class);
        DubboBeanUtils.registerInfrastructureBean(registry, "dubboInfraBeanRegisterPostProcessor", DubboInfraBeanRegisterPostProcessor.class);
    }

    public static boolean registerInfrastructureBean(BeanDefinitionRegistry beanDefinitionRegistry, String beanName, Class<?> beanType) {
        boolean registered = false;
        if (!beanDefinitionRegistry.containsBeanDefinition(beanName)) {
            RootBeanDefinition beanDefinition = new RootBeanDefinition(beanType);
            beanDefinition.setRole(2);
            beanDefinitionRegistry.registerBeanDefinition(beanName, (BeanDefinition)beanDefinition);
            registered = true;
            if (log.isDebugEnabled()) {
                log.debug((Object)("The Infrastructure bean definition [" + beanDefinition + "with name [" + beanName + "] has been registered."));
            }
        }
        return registered;
    }

    public static void registerBeansIfNotExists(BeanDefinitionRegistry registry) {
        if (!DubboBeanUtils.checkBeanExists(registry, PropertyPlaceholderConfigurer.class)) {
            HashMap<String, Object> propertySourcesPlaceholderPropertyValues = new HashMap<String, Object>();
            propertySourcesPlaceholderPropertyValues.put("order", 0);
            DubboBeanUtils.registerBeanDefinitionIfNotExists(registry, PropertySourcesPlaceholderConfigurer.class.getName(), PropertySourcesPlaceholderConfigurer.class, propertySourcesPlaceholderPropertyValues);
        }
    }

    public static boolean registerBeanDefinitionIfNotExists(BeanDefinitionRegistry registry, String beanName, Class<?> beanClass, Map<String, Object> extraPropertyValues) {
        if (registry.containsBeanDefinition(beanName)) {
            return false;
        }
        if (DubboBeanUtils.checkBeanExists(registry, beanClass)) {
            return false;
        }
        AbstractBeanDefinition beanDefinition = BeanDefinitionBuilder.genericBeanDefinition(beanClass).getBeanDefinition();
        if (extraPropertyValues != null) {
            for (Map.Entry<String, Object> entry : extraPropertyValues.entrySet()) {
                beanDefinition.getPropertyValues().add(entry.getKey(), entry.getValue());
            }
        }
        registry.registerBeanDefinition(beanName, (BeanDefinition)beanDefinition);
        return true;
    }

    public static boolean checkBeanExists(BeanDefinitionRegistry registry, Class<?> beanClass) {
        String[] candidates;
        for (String candidate : candidates = registry.getBeanDefinitionNames()) {
            BeanDefinition beanDefinition = registry.getBeanDefinition(candidate);
            if (!Objects.equals(beanDefinition.getBeanClassName(), beanClass.getName())) continue;
            return true;
        }
        return false;
    }
}

