/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.spring.context;

import java.util.SortedMap;
import org.apache.dubbo.common.extension.ExtensionAccessor;
import org.apache.dubbo.config.spring.beans.factory.annotation.ReferenceAnnotationBeanPostProcessor;
import org.apache.dubbo.config.spring.extension.SpringExtensionInjector;
import org.apache.dubbo.config.spring.util.DubboBeanUtils;
import org.apache.dubbo.config.spring.util.EnvironmentUtils;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.ModuleModel;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.env.ConfigurableEnvironment;

public class DubboInfraBeanRegisterPostProcessor
implements BeanDefinitionRegistryPostProcessor,
ApplicationContextAware {
    public static final String BEAN_NAME = "dubboInfraBeanRegisterPostProcessor";
    private BeanDefinitionRegistry registry;
    private ApplicationContext applicationContext;

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
        this.registry = registry;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        if (this.registry != null) {
            ReferenceAnnotationBeanPostProcessor referenceAnnotationBeanPostProcessor = (ReferenceAnnotationBeanPostProcessor)((Object)beanFactory.getBean("referenceAnnotationBeanPostProcessor", ReferenceAnnotationBeanPostProcessor.class));
            beanFactory.addBeanPostProcessor((BeanPostProcessor)referenceAnnotationBeanPostProcessor);
            DubboBeanUtils.registerPlaceholderConfigurerBeanIfNotExists(beanFactory, this.registry);
        }
        ApplicationModel applicationModel = DubboBeanUtils.getApplicationModel((BeanFactory)beanFactory);
        ModuleModel moduleModel = DubboBeanUtils.getModuleModel((BeanFactory)beanFactory);
        SpringExtensionInjector.get((ExtensionAccessor)applicationModel).init(this.applicationContext);
        SpringExtensionInjector.get((ExtensionAccessor)moduleModel).init(this.applicationContext);
        DubboBeanUtils.getInitializationContext((BeanFactory)beanFactory).setApplicationContext(this.applicationContext);
        ConfigurableEnvironment environment = (ConfigurableEnvironment)this.applicationContext.getEnvironment();
        SortedMap<String, String> dubboProperties = EnvironmentUtils.filterDubboProperties(environment);
        applicationModel.getModelEnvironment().setAppConfigMap(dubboProperties);
        beanFactory.registerSingleton("dubboConfigManager", (Object)applicationModel.getApplicationConfigManager());
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

