/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.spring.extension;

import com.alibaba.spring.util.BeanFactoryUtils;
import java.util.Set;
import org.apache.dubbo.common.context.Lifecycle;
import org.apache.dubbo.common.extension.ExtensionFactory;
import org.apache.dubbo.common.extension.SPI;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.ConcurrentHashSet;
import org.apache.dubbo.config.DubboShutdownHook;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;

public class SpringExtensionFactory
implements ExtensionFactory,
Lifecycle {
    private static final Logger logger = LoggerFactory.getLogger(SpringExtensionFactory.class);
    private static final Set<ApplicationContext> CONTEXTS = new ConcurrentHashSet();

    public static void addApplicationContext(ApplicationContext context) {
        CONTEXTS.add(context);
        if (context instanceof ConfigurableApplicationContext) {
            ((ConfigurableApplicationContext)context).registerShutdownHook();
            DubboShutdownHook.getDubboShutdownHook().unregister();
        }
    }

    public static void removeApplicationContext(ApplicationContext context) {
        CONTEXTS.remove(context);
    }

    public static Set<ApplicationContext> getContexts() {
        return CONTEXTS;
    }

    public static void clearContexts() {
        CONTEXTS.clear();
    }

    public <T> T getExtension(Class<T> type, String name) {
        if (type.isInterface() && type.isAnnotationPresent(SPI.class)) {
            return null;
        }
        for (ApplicationContext context : CONTEXTS) {
            Object bean = BeanFactoryUtils.getOptionalBean((ListableBeanFactory)context, (String)name, type);
            if (bean == null) continue;
            return (T)bean;
        }
        return null;
    }

    public void initialize() throws IllegalStateException {
        SpringExtensionFactory.clearContexts();
    }

    public void start() throws IllegalStateException {
    }

    public void destroy() {
        SpringExtensionFactory.clearContexts();
    }
}

