/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.spring.reference;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.dubbo.config.ConsumerConfig;
import org.apache.dubbo.config.MethodConfig;
import org.apache.dubbo.config.MonitorConfig;
import org.apache.dubbo.config.RegistryConfig;
import org.apache.dubbo.config.spring.ReferenceBean;

public class ReferenceBeanBuilder {
    private Map<String, Object> attributes = new HashMap<String, Object>();

    public <T> ReferenceBean<T> build() {
        return new ReferenceBean(this.attributes);
    }

    public ReferenceBeanBuilder setServices(String services) {
        this.attributes.put("services", services);
        return this;
    }

    public ReferenceBeanBuilder setInterface(String interfaceName) {
        this.attributes.put("interfaceName", interfaceName);
        return this;
    }

    public ReferenceBeanBuilder setInterface(Class interfaceClass) {
        this.attributes.put("interfaceClass", interfaceClass);
        return this;
    }

    public ReferenceBeanBuilder setClient(String client) {
        this.attributes.put("client", client);
        return this;
    }

    public ReferenceBeanBuilder setUrl(String url) {
        this.attributes.put("url", url);
        return this;
    }

    public ReferenceBeanBuilder setConsumer(ConsumerConfig consumer) {
        this.attributes.put("consumer", consumer);
        return this;
    }

    public ReferenceBeanBuilder setConsumer(String consumer) {
        this.attributes.put("consumer", consumer);
        return this;
    }

    public ReferenceBeanBuilder setProtocol(String protocol) {
        this.attributes.put("protocol", protocol);
        return this;
    }

    public ReferenceBeanBuilder setCheck(Boolean check) {
        this.attributes.put("check", check);
        return this;
    }

    public ReferenceBeanBuilder setInit(Boolean init) {
        this.attributes.put("init", init);
        return this;
    }

    public ReferenceBeanBuilder setGeneric(Boolean generic) {
        this.attributes.put("generic", generic);
        return this;
    }

    @Deprecated
    public ReferenceBeanBuilder setInjvm(Boolean injvm) {
        this.attributes.put("injvm", injvm);
        return this;
    }

    public ReferenceBeanBuilder setListener(String listener) {
        this.attributes.put("listener", listener);
        return this;
    }

    public ReferenceBeanBuilder setLazy(Boolean lazy) {
        this.attributes.put("lazy", lazy);
        return this;
    }

    public ReferenceBeanBuilder setOnconnect(String onconnect) {
        this.attributes.put("onconnect", onconnect);
        return this;
    }

    public ReferenceBeanBuilder setOndisconnect(String ondisconnect) {
        this.attributes.put("ondisconnect", ondisconnect);
        return this;
    }

    public ReferenceBeanBuilder setReconnect(String reconnect) {
        this.attributes.put("reconnect", reconnect);
        return this;
    }

    public ReferenceBeanBuilder setSticky(Boolean sticky) {
        this.attributes.put("sticky", sticky);
        return this;
    }

    public ReferenceBeanBuilder setVersion(String version) {
        this.attributes.put("version", version);
        return this;
    }

    public ReferenceBeanBuilder setGroup(String group) {
        this.attributes.put("group", group);
        return this;
    }

    public ReferenceBeanBuilder setProvidedBy(String providedBy) {
        this.attributes.put("providedBy", providedBy);
        return this;
    }

    public ReferenceBeanBuilder setStub(String stub) {
        this.attributes.put("stub", stub);
        return this;
    }

    public ReferenceBeanBuilder setCluster(String cluster) {
        this.attributes.put("cluster", cluster);
        return this;
    }

    public ReferenceBeanBuilder setProxy(String proxy) {
        this.attributes.put("proxy", proxy);
        return this;
    }

    public ReferenceBeanBuilder setConnections(Integer connections) {
        this.attributes.put("connections", connections);
        return this;
    }

    public ReferenceBeanBuilder setFilter(String filter) {
        this.attributes.put("filter", filter);
        return this;
    }

    public ReferenceBeanBuilder setLayer(String layer) {
        this.attributes.put("layer", layer);
        return this;
    }

    public ReferenceBeanBuilder setRegistry(String[] registryIds) {
        this.attributes.put("registry", registryIds);
        return this;
    }

    public ReferenceBeanBuilder setRegistry(RegistryConfig registry) {
        this.setRegistries(Arrays.asList(registry));
        return this;
    }

    public ReferenceBeanBuilder setRegistries(List<? extends RegistryConfig> registries) {
        this.attributes.put("registries", registries);
        return this;
    }

    public ReferenceBeanBuilder setMethods(List<? extends MethodConfig> methods) {
        this.attributes.put("methods", methods);
        return this;
    }

    @Deprecated
    public ReferenceBeanBuilder setMonitor(MonitorConfig monitor) {
        this.attributes.put("monitor", monitor);
        return this;
    }

    @Deprecated
    public ReferenceBeanBuilder setMonitor(String monitor) {
        this.attributes.put("monitor", monitor);
        return this;
    }

    public ReferenceBeanBuilder setOwner(String owner) {
        this.attributes.put("owner", owner);
        return this;
    }

    public ReferenceBeanBuilder setCallbacks(Integer callbacks) {
        this.attributes.put("callbacks", callbacks);
        return this;
    }

    public ReferenceBeanBuilder setScope(String scope) {
        this.attributes.put("scope", scope);
        return this;
    }

    public ReferenceBeanBuilder setTag(String tag) {
        this.attributes.put("tag", tag);
        return this;
    }

    public ReferenceBeanBuilder setTimeout(Integer timeout) {
        this.attributes.put("timeout", timeout);
        return this;
    }

    public ReferenceBeanBuilder setRetries(Integer retries) {
        this.attributes.put("retries", retries);
        return this;
    }

    public ReferenceBeanBuilder setLoadBalance(String loadbalance) {
        this.attributes.put("loadbalance", loadbalance);
        return this;
    }

    public ReferenceBeanBuilder setAsync(Boolean async) {
        this.attributes.put("async", async);
        return this;
    }

    public ReferenceBeanBuilder setActives(Integer actives) {
        this.attributes.put("actives", actives);
        return this;
    }

    public ReferenceBeanBuilder setSent(Boolean sent) {
        this.attributes.put("sent", sent);
        return this;
    }

    public ReferenceBeanBuilder setMock(String mock) {
        this.attributes.put("mock", mock);
        return this;
    }

    public ReferenceBeanBuilder setMerger(String merger) {
        this.attributes.put("merger", merger);
        return this;
    }

    public ReferenceBeanBuilder setCache(String cache) {
        this.attributes.put("cache", cache);
        return this;
    }

    public ReferenceBeanBuilder setValidation(String validation) {
        this.attributes.put("validation", validation);
        return this;
    }

    public ReferenceBeanBuilder setParameters(Map<String, String> parameters) {
        this.attributes.put("parameters", parameters);
        return this;
    }
}

