/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.spring;

import java.util.HashMap;
import java.util.Map;
import org.apache.dubbo.common.config.ConfigurationUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.config.ConfigCenterConfig;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySource;

public class ConfigCenterBean
extends ConfigCenterConfig
implements ApplicationContextAware,
DisposableBean,
EnvironmentAware {
    private transient ApplicationContext applicationContext;
    private Boolean includeSpringEnv = false;

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void destroy() throws Exception {
    }

    public void setEnvironment(Environment environment) {
        if (this.includeSpringEnv.booleanValue()) {
            this.setExternalConfig(this.getConfigurations(this.getConfigFile(), environment));
            this.setAppExternalConfig(this.getConfigurations(StringUtils.isNotEmpty((String)this.getAppConfigFile()) ? this.getAppConfigFile() : "application." + this.getConfigFile(), environment));
        }
    }

    private Map<String, String> getConfigurations(String key, Environment environment) {
        Object rawProperties = environment.getProperty(key, Object.class);
        HashMap<String, String> externalProperties = new HashMap<String, String>();
        try {
            Object source;
            ConfigurableEnvironment configurableEnvironment;
            PropertySource propertySource;
            if (rawProperties instanceof Map) {
                externalProperties.putAll((Map)rawProperties);
            } else if (rawProperties instanceof String) {
                externalProperties.putAll(ConfigurationUtils.parseProperties((String)((String)rawProperties)));
            }
            if (environment instanceof ConfigurableEnvironment && externalProperties.isEmpty() && (propertySource = (configurableEnvironment = (ConfigurableEnvironment)environment).getPropertySources().get(key)) != null && (source = propertySource.getSource()) instanceof Map) {
                ((Map)source).forEach((k, v) -> externalProperties.put((String)k, (String)v));
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        return externalProperties;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public Boolean getIncludeSpringEnv() {
        return this.includeSpringEnv;
    }

    public void setIncludeSpringEnv(Boolean includeSpringEnv) {
        this.includeSpringEnv = includeSpringEnv;
    }
}

