/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.spring.context;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.dubbo.config.AbstractConfig;
import org.apache.dubbo.config.ApplicationConfig;
import org.apache.dubbo.config.ConsumerConfig;
import org.apache.dubbo.config.MetadataReportConfig;
import org.apache.dubbo.config.MetricsConfig;
import org.apache.dubbo.config.ModuleConfig;
import org.apache.dubbo.config.MonitorConfig;
import org.apache.dubbo.config.ProtocolConfig;
import org.apache.dubbo.config.ProviderConfig;
import org.apache.dubbo.config.RegistryConfig;
import org.apache.dubbo.config.SslConfig;
import org.apache.dubbo.config.context.AbstractConfigManager;
import org.apache.dubbo.config.context.ConfigManager;
import org.apache.dubbo.config.spring.ConfigCenterBean;
import org.apache.dubbo.config.spring.reference.ReferenceBeanManager;
import org.apache.dubbo.rpc.model.ModuleModel;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;

public class DubboConfigBeanInitializer
implements BeanFactoryAware,
InitializingBean {
    public static String BEAN_NAME = "dubboConfigBeanInitializer";
    private final Log logger = LogFactory.getLog(this.getClass());
    private AtomicBoolean initialized = new AtomicBoolean(false);
    private ConfigurableListableBeanFactory beanFactory;
    private ReferenceBeanManager referenceBeanManager;
    @Autowired
    private ConfigManager configManager;
    @Autowired
    @Qualifier(value="org.apache.dubbo.rpc.model.ModuleModel")
    private ModuleModel moduleModel;

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = (ConfigurableListableBeanFactory)beanFactory;
    }

    public void afterPropertiesSet() throws Exception {
        this.init();
    }

    private void init() {
        if (this.initialized.compareAndSet(false, true)) {
            this.referenceBeanManager = (ReferenceBeanManager)this.beanFactory.getBean("dubboReferenceBeanManager", ReferenceBeanManager.class);
            try {
                this.prepareDubboConfigBeans();
                this.referenceBeanManager.prepareReferenceBeans();
            }
            catch (Throwable e) {
                throw new FatalBeanException("Initialization dubbo config beans failed", e);
            }
        }
    }

    private void prepareDubboConfigBeans() {
        this.logger.info((Object)"loading dubbo config beans ...");
        this.loadConfigBeansOfType(ApplicationConfig.class, (AbstractConfigManager)this.configManager);
        this.loadConfigBeansOfType(RegistryConfig.class, (AbstractConfigManager)this.configManager);
        this.loadConfigBeansOfType(ProtocolConfig.class, (AbstractConfigManager)this.configManager);
        this.loadConfigBeansOfType(MonitorConfig.class, (AbstractConfigManager)this.configManager);
        this.loadConfigBeansOfType(ConfigCenterBean.class, (AbstractConfigManager)this.configManager);
        this.loadConfigBeansOfType(MetadataReportConfig.class, (AbstractConfigManager)this.configManager);
        this.loadConfigBeansOfType(MetricsConfig.class, (AbstractConfigManager)this.configManager);
        this.loadConfigBeansOfType(SslConfig.class, (AbstractConfigManager)this.configManager);
        this.loadConfigBeansOfType(ModuleConfig.class, (AbstractConfigManager)this.moduleModel.getConfigManager());
        this.loadConfigBeansOfType(ProviderConfig.class, (AbstractConfigManager)this.moduleModel.getConfigManager());
        this.loadConfigBeansOfType(ConsumerConfig.class, (AbstractConfigManager)this.moduleModel.getConfigManager());
        this.logger.info((Object)"dubbo config beans are loaded.");
    }

    private void loadConfigBeansOfType(Class<? extends AbstractConfig> configClass, AbstractConfigManager configManager) {
        String[] beanNames;
        for (String beanName : beanNames = this.beanFactory.getBeanNamesForType(configClass, true, false)) {
            AbstractConfig configBean = (AbstractConfig)this.beanFactory.getBean(beanName, configClass);
            configManager.addConfig(configBean);
        }
    }
}

