/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.spring.context;

import java.util.concurrent.Future;
import org.apache.dubbo.common.deploy.DeployListener;
import org.apache.dubbo.common.deploy.DeployListenerAdapter;
import org.apache.dubbo.common.deploy.DeployState;
import org.apache.dubbo.common.deploy.ModuleDeployer;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.Assert;
import org.apache.dubbo.config.spring.context.event.DubboApplicationStateEvent;
import org.apache.dubbo.config.spring.util.DubboBeanUtils;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.ModuleModel;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ApplicationContextEvent;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.Ordered;

public class DubboDeployApplicationListener
implements ApplicationListener<ApplicationContextEvent>,
ApplicationContextAware,
Ordered {
    private static final Logger logger = LoggerFactory.getLogger(DubboDeployApplicationListener.class);
    private ApplicationContext applicationContext;
    private ApplicationModel applicationModel;
    private ModuleModel moduleModel;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
        this.applicationModel = DubboBeanUtils.getApplicationModel((BeanFactory)applicationContext);
        this.moduleModel = DubboBeanUtils.getModuleModel((BeanFactory)applicationContext);
        this.applicationModel.getDeployer().addDeployListener((DeployListener)new DeployListenerAdapter<ApplicationModel>(){

            public void onStarting(ApplicationModel scopeModel) {
                DubboDeployApplicationListener.this.publishEvent(DeployState.STARTING);
            }

            public void onStarted(ApplicationModel scopeModel) {
                DubboDeployApplicationListener.this.publishEvent(DeployState.STARTED);
            }

            public void onStopping(ApplicationModel scopeModel) {
                DubboDeployApplicationListener.this.publishEvent(DeployState.STOPPING);
            }

            public void onStopped(ApplicationModel scopeModel) {
                DubboDeployApplicationListener.this.publishEvent(DeployState.STOPPED);
            }

            public void onFailure(ApplicationModel scopeModel, Throwable cause) {
                DubboDeployApplicationListener.this.publishEvent(DeployState.FAILED, cause);
            }
        });
    }

    private void publishEvent(DeployState state) {
        this.applicationContext.publishEvent((ApplicationEvent)new DubboApplicationStateEvent(this.applicationModel, state));
    }

    private void publishEvent(DeployState state, Throwable cause) {
        this.applicationContext.publishEvent((ApplicationEvent)new DubboApplicationStateEvent(this.applicationModel, state, cause));
    }

    public void onApplicationEvent(ApplicationContextEvent event) {
        if (event instanceof ContextRefreshedEvent) {
            this.onContextRefreshedEvent((ContextRefreshedEvent)event);
        } else if (event instanceof ContextClosedEvent) {
            this.onContextClosedEvent((ContextClosedEvent)event);
        }
    }

    private void onContextRefreshedEvent(ContextRefreshedEvent event) {
        ModuleDeployer deployer = this.moduleModel.getDeployer();
        Assert.notNull((Object)deployer, (String)"Module deployer is null");
        Future future = deployer.start();
        if (!deployer.isBackground()) {
            try {
                future.get();
            }
            catch (InterruptedException e) {
                logger.warn("Interrupted while waiting for dubbo module start: " + e.getMessage());
            }
            catch (Exception e) {
                logger.warn("An error occurred while waiting for dubbo module start: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    private void onContextClosedEvent(ContextClosedEvent event) {
        try {
            Object value = this.moduleModel.getAttribute("keepRunningOnSpringClosed");
            boolean keepRunningOnClosed = Boolean.parseBoolean(String.valueOf(value));
            if (!keepRunningOnClosed && !this.moduleModel.isDestroyed()) {
                this.moduleModel.destroy();
            }
        }
        catch (Exception e) {
            logger.error("An error occurred when stop dubbo module: " + e.getMessage(), (Throwable)e);
        }
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }
}

