/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.spring.context;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.dubbo.config.spring.context.DubboSpringInitContext;
import org.apache.dubbo.config.spring.context.DubboSpringInitCustomizer;
import org.apache.dubbo.config.spring.context.DubboSpringInitCustomizerHolder;
import org.apache.dubbo.config.spring.util.DubboBeanUtils;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.model.ModuleModel;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.support.GenericApplicationContext;

public class DubboSpringInitializer {
    private static Map<BeanDefinitionRegistry, DubboSpringInitContext> contextMap = new ConcurrentHashMap<BeanDefinitionRegistry, DubboSpringInitContext>();

    private DubboSpringInitializer() {
    }

    public static void initialize(BeanDefinitionRegistry registry) {
        if (contextMap.putIfAbsent(registry, new DubboSpringInitContext()) != null) {
            return;
        }
        DubboSpringInitContext context = contextMap.get(registry);
        ConfigurableListableBeanFactory beanFactory = DubboSpringInitializer.findBeanFactory(registry);
        DubboSpringInitializer.initContext(context, registry, beanFactory);
    }

    private static void initContext(DubboSpringInitContext context, BeanDefinitionRegistry registry, ConfigurableListableBeanFactory beanFactory) {
        context.setRegistry(registry);
        context.setBeanFactory(beanFactory);
        DubboSpringInitializer.customize(context);
        ApplicationModel applicationModel = context.getApplicationModel();
        if (applicationModel == null) {
            applicationModel = DubboSpringInitializer.findContextForApplication(ApplicationModel.defaultModel()) == null ? ApplicationModel.defaultModel() : FrameworkModel.defaultModel().newApplication();
            ModuleModel moduleModel = applicationModel.getDefaultModule();
            context.setModuleModel(moduleModel);
        }
        if (context.getModuleAttributes().size() > 0) {
            context.getModuleModel().getAttributes().putAll(context.getModuleAttributes());
        }
        DubboSpringInitializer.registerContextBeans(beanFactory, context);
        context.markAsBound();
        DubboBeanUtils.registerCommonBeans(registry);
    }

    private static ConfigurableListableBeanFactory findBeanFactory(BeanDefinitionRegistry registry) {
        ConfigurableListableBeanFactory beanFactory = null;
        if (registry instanceof ConfigurableListableBeanFactory) {
            beanFactory = (ConfigurableListableBeanFactory)registry;
        } else if (registry instanceof GenericApplicationContext) {
            GenericApplicationContext genericApplicationContext = (GenericApplicationContext)registry;
            beanFactory = genericApplicationContext.getBeanFactory();
        } else {
            throw new IllegalStateException("Can not find Spring BeanFactory from registry: " + registry.getClass().getName());
        }
        return beanFactory;
    }

    private static void registerContextBeans(ConfigurableListableBeanFactory beanFactory, DubboSpringInitContext context) {
        DubboSpringInitializer.registerSingleton(beanFactory, context);
        DubboSpringInitializer.registerSingleton(beanFactory, context.getApplicationModel());
        DubboSpringInitializer.registerSingleton(beanFactory, context.getModuleModel());
    }

    private static void registerSingleton(ConfigurableListableBeanFactory beanFactory, Object bean) {
        beanFactory.registerSingleton(bean.getClass().getName(), bean);
    }

    private static DubboSpringInitContext findContextForApplication(ApplicationModel applicationModel) {
        for (DubboSpringInitContext initializationContext : contextMap.values()) {
            if (initializationContext.getApplicationModel() != applicationModel) continue;
            return initializationContext;
        }
        return null;
    }

    private static void customize(DubboSpringInitContext context) {
        Set<DubboSpringInitCustomizer> customizers = FrameworkModel.defaultModel().getExtensionLoader(DubboSpringInitCustomizer.class).getSupportedExtensionInstances();
        for (DubboSpringInitCustomizer customizer : customizers) {
            customizer.customize(context);
        }
        DubboSpringInitCustomizerHolder customizerHolder = DubboSpringInitCustomizerHolder.get();
        customizers = customizerHolder.getCustomizers();
        for (DubboSpringInitCustomizer customizer : customizers) {
            customizer.customize(context);
        }
        customizerHolder.clearCustomizers();
    }
}

