/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.spring.context;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.config.spring.context.DubboSpringInitContext;
import org.apache.dubbo.config.spring.context.DubboSpringInitCustomizer;
import org.apache.dubbo.config.spring.context.DubboSpringInitCustomizerHolder;
import org.apache.dubbo.config.spring.util.DubboBeanUtils;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.model.ModuleModel;
import org.apache.dubbo.rpc.model.ScopeModel;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.util.ObjectUtils;

public class DubboSpringInitializer {
    private static final Logger logger = LoggerFactory.getLogger(DubboSpringInitializer.class);
    private static Map<BeanDefinitionRegistry, DubboSpringInitContext> contextMap = new ConcurrentHashMap<BeanDefinitionRegistry, DubboSpringInitContext>();

    private DubboSpringInitializer() {
    }

    public static void initialize(BeanDefinitionRegistry registry) {
        if (contextMap.putIfAbsent(registry, new DubboSpringInitContext()) != null) {
            return;
        }
        DubboSpringInitContext context = contextMap.get(registry);
        ConfigurableListableBeanFactory beanFactory = DubboSpringInitializer.findBeanFactory(registry);
        DubboSpringInitializer.initContext(context, registry, beanFactory);
    }

    public static boolean remove(BeanDefinitionRegistry registry) {
        return contextMap.remove(registry) != null;
    }

    public static boolean remove(ApplicationContext springContext) {
        for (Map.Entry<BeanDefinitionRegistry, DubboSpringInitContext> entry : contextMap.entrySet()) {
            DubboSpringInitContext initContext = entry.getValue();
            if (initContext.getApplicationContext() != springContext && initContext.getBeanFactory() != springContext.getAutowireCapableBeanFactory() && initContext.getRegistry() != springContext.getAutowireCapableBeanFactory()) continue;
            DubboSpringInitContext context = contextMap.remove(entry.getKey());
            logger.info("Unbind " + DubboSpringInitializer.safeGetModelDesc((ScopeModel)context.getModuleModel()) + " from spring container: " + ObjectUtils.identityToString((Object)entry.getKey()));
            return true;
        }
        return false;
    }

    static Map<BeanDefinitionRegistry, DubboSpringInitContext> getContextMap() {
        return contextMap;
    }

    static DubboSpringInitContext findBySpringContext(ApplicationContext applicationContext) {
        for (Map.Entry<BeanDefinitionRegistry, DubboSpringInitContext> entry : contextMap.entrySet()) {
            DubboSpringInitContext initContext = entry.getValue();
            if (initContext.getApplicationContext() != applicationContext) continue;
            return initContext;
        }
        return null;
    }

    private static void initContext(DubboSpringInitContext context, BeanDefinitionRegistry registry, ConfigurableListableBeanFactory beanFactory) {
        context.setRegistry(registry);
        context.setBeanFactory(beanFactory);
        DubboSpringInitializer.customize(context);
        ModuleModel moduleModel = context.getModuleModel();
        if (moduleModel == null) {
            ApplicationModel applicationModel;
            if (DubboSpringInitializer.findContextForApplication(ApplicationModel.defaultModel()) == null) {
                applicationModel = ApplicationModel.defaultModel();
                logger.info("Use default application: " + DubboSpringInitializer.safeGetModelDesc((ScopeModel)applicationModel));
            } else {
                applicationModel = FrameworkModel.defaultModel().newApplication();
                logger.info("Create new application: " + DubboSpringInitializer.safeGetModelDesc((ScopeModel)applicationModel));
            }
            moduleModel = applicationModel.getDefaultModule();
            context.setModuleModel(moduleModel);
            logger.info("Use default module model of target application: " + DubboSpringInitializer.safeGetModelDesc((ScopeModel)moduleModel));
        } else {
            logger.info("Use module model from customizer: " + DubboSpringInitializer.safeGetModelDesc((ScopeModel)moduleModel));
        }
        logger.info("Bind " + DubboSpringInitializer.safeGetModelDesc((ScopeModel)moduleModel) + " to spring container: " + ObjectUtils.identityToString((Object)registry));
        if (context.getModuleAttributes().size() > 0) {
            context.getModuleModel().getAttributes().putAll(context.getModuleAttributes());
        }
        DubboSpringInitializer.registerContextBeans(beanFactory, context);
        context.markAsBound();
        DubboBeanUtils.registerCommonBeans(registry);
    }

    private static String safeGetModelDesc(ScopeModel scopeModel) {
        return scopeModel != null ? scopeModel.getDesc() : null;
    }

    private static ConfigurableListableBeanFactory findBeanFactory(BeanDefinitionRegistry registry) {
        ConfigurableListableBeanFactory beanFactory;
        if (registry instanceof ConfigurableListableBeanFactory) {
            beanFactory = (ConfigurableListableBeanFactory)registry;
        } else if (registry instanceof GenericApplicationContext) {
            GenericApplicationContext genericApplicationContext = (GenericApplicationContext)registry;
            beanFactory = genericApplicationContext.getBeanFactory();
        } else {
            throw new IllegalStateException("Can not find Spring BeanFactory from registry: " + registry.getClass().getName());
        }
        return beanFactory;
    }

    private static void registerContextBeans(ConfigurableListableBeanFactory beanFactory, DubboSpringInitContext context) {
        DubboSpringInitializer.registerSingleton(beanFactory, context);
        DubboSpringInitializer.registerSingleton(beanFactory, context.getApplicationModel());
        DubboSpringInitializer.registerSingleton(beanFactory, context.getModuleModel());
    }

    private static void registerSingleton(ConfigurableListableBeanFactory beanFactory, Object bean) {
        beanFactory.registerSingleton(bean.getClass().getName(), bean);
    }

    private static DubboSpringInitContext findContextForApplication(ApplicationModel applicationModel) {
        for (DubboSpringInitContext initializationContext : contextMap.values()) {
            if (initializationContext.getApplicationModel() != applicationModel) continue;
            return initializationContext;
        }
        return null;
    }

    private static void customize(DubboSpringInitContext context) {
        Set<DubboSpringInitCustomizer> customizers = FrameworkModel.defaultModel().getExtensionLoader(DubboSpringInitCustomizer.class).getSupportedExtensionInstances();
        for (DubboSpringInitCustomizer customizer : customizers) {
            customizer.customize(context);
        }
        DubboSpringInitCustomizerHolder customizerHolder = DubboSpringInitCustomizerHolder.get();
        customizers = customizerHolder.getCustomizers();
        for (DubboSpringInitCustomizer customizer : customizers) {
            customizer.customize(context);
        }
        customizerHolder.clearCustomizers();
    }
}

