/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.spring;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.dubbo.common.utils.Assert;
import org.apache.dubbo.common.utils.ClassUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.config.ReferenceConfig;
import org.apache.dubbo.config.spring.reference.ReferenceBeanManager;
import org.apache.dubbo.config.spring.reference.ReferenceBeanSupport;
import org.apache.dubbo.config.support.Parameter;
import org.apache.dubbo.rpc.proxy.AbstractProxyFactory;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.target.AbstractLazyCreationTargetSource;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.DefaultSingletonBeanRegistry;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class ReferenceBean<T>
implements FactoryBean<T>,
ApplicationContextAware,
BeanClassLoaderAware,
BeanNameAware,
InitializingBean,
DisposableBean {
    private transient ApplicationContext applicationContext;
    private ClassLoader beanClassLoader;
    private Object lazyProxy;
    protected String id;
    private String key;
    private Class<?> interfaceClass;
    private String interfaceName;
    private Map<String, Object> referenceProps;
    private MutablePropertyValues propertyValues;
    private ReferenceConfig referenceConfig;
    private List<Map<String, Object>> sources = new ArrayList<Map<String, Object>>();

    public ReferenceBean() {
    }

    public ReferenceBean(Map<String, Object> referenceProps) {
        this.referenceProps = referenceProps;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    public void setBeanName(String name) {
        this.setId(name);
    }

    public T getObject() {
        if (this.lazyProxy == null) {
            this.createLazyProxy();
        }
        return (T)this.lazyProxy;
    }

    public Class<?> getObjectType() {
        return this.getInterfaceClass();
    }

    @Parameter(excluded=true)
    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() throws Exception {
        ConfigurableListableBeanFactory beanFactory = this.getBeanFactory();
        Assert.notEmptyString((String)this.getId(), (String)"The id of ReferenceBean cannot be empty");
        BeanDefinition beanDefinition = beanFactory.getBeanDefinition(this.getId());
        this.interfaceClass = (Class)beanDefinition.getAttribute("interfaceClass");
        this.interfaceName = (String)beanDefinition.getAttribute("interfaceName");
        Assert.notNull(this.interfaceClass, (String)"The interface class of ReferenceBean is not initialized");
        if (beanDefinition.hasAttribute("referenceProps")) {
            this.referenceProps = (Map)beanDefinition.getAttribute("referenceProps");
        } else if (beanDefinition instanceof AnnotatedBeanDefinition) {
            if (this.referenceProps == null) {
                this.referenceProps = new LinkedHashMap<String, Object>();
            }
            ReferenceBeanSupport.convertReferenceProps(this.referenceProps, this.interfaceClass);
            if (this.interfaceName == null) {
                this.interfaceName = (String)this.referenceProps.get("interface");
            }
        } else {
            this.propertyValues = beanDefinition.getPropertyValues();
        }
        Assert.notNull((Object)this.interfaceName, (String)"The interface name of ReferenceBean is not initialized");
        ReferenceBeanManager referenceBeanManager = (ReferenceBeanManager)beanFactory.getBean("dubboReferenceBeanManager", ReferenceBeanManager.class);
        referenceBeanManager.addReference(this);
    }

    private ConfigurableListableBeanFactory getBeanFactory() {
        return (ConfigurableListableBeanFactory)this.applicationContext.getAutowireCapableBeanFactory();
    }

    public void destroy() {
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Class<?> getInterfaceClass() {
        return this.interfaceClass;
    }

    public String getServiceInterface() {
        return this.interfaceName;
    }

    public String getGroup() {
        return this.referenceConfig.getGroup();
    }

    public String getVersion() {
        return this.referenceConfig.getVersion();
    }

    public String getKey() {
        return this.key;
    }

    public Map<String, Object> getReferenceProps() {
        return this.referenceProps;
    }

    public MutablePropertyValues getPropertyValues() {
        return this.propertyValues;
    }

    public ReferenceConfig getReferenceConfig() {
        return this.referenceConfig;
    }

    public void setKeyAndReferenceConfig(String key, ReferenceConfig referenceConfig) {
        this.key = key;
        this.referenceConfig = referenceConfig;
    }

    private void createLazyProxy() {
        Class[] internalInterfaces;
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.setTargetSource((TargetSource)new DubboReferenceLazyInitTargetSource());
        proxyFactory.addInterface(this.interfaceClass);
        for (Class anInterface : internalInterfaces = AbstractProxyFactory.getInternalInterfaces()) {
            proxyFactory.addInterface(anInterface);
        }
        if (!StringUtils.isEquals((String)this.interfaceClass.getName(), (String)this.interfaceName)) {
            try {
                Class serviceInterface = ClassUtils.forName((String)this.interfaceName, (ClassLoader)this.beanClassLoader);
                proxyFactory.addInterface(serviceInterface);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        this.lazyProxy = proxyFactory.getProxy(this.beanClassLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getCallProxy() throws Exception {
        if (this.referenceConfig == null) {
            throw new IllegalStateException("ReferenceBean is not ready yet, please make sure to call reference interface method after dubbo is started.");
        }
        Object object = ((DefaultSingletonBeanRegistry)this.getBeanFactory()).getSingletonMutex();
        synchronized (object) {
            return this.referenceConfig.get();
        }
    }

    private class DubboReferenceLazyInitTargetSource
    extends AbstractLazyCreationTargetSource {
        private DubboReferenceLazyInitTargetSource() {
        }

        protected Object createObject() throws Exception {
            return ReferenceBean.this.getCallProxy();
        }

        public synchronized Class<?> getTargetClass() {
            return ReferenceBean.this.getInterfaceClass();
        }
    }
}

