/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.spring.status;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.extension.ExtensionAccessor;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.status.Status;
import org.apache.dubbo.common.status.StatusChecker;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.config.spring.extension.SpringExtensionInjector;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.springframework.context.ApplicationContext;

@Activate
public class DataSourceStatusChecker
implements StatusChecker {
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(DataSourceStatusChecker.class);
    private ApplicationModel applicationModel;
    private ApplicationContext applicationContext;

    public DataSourceStatusChecker(ApplicationModel applicationModel) {
        this.applicationModel = applicationModel;
    }

    public DataSourceStatusChecker(ApplicationContext context) {
        this.applicationContext = context;
    }

    public Status check() {
        if (this.applicationContext == null) {
            SpringExtensionInjector springExtensionInjector = SpringExtensionInjector.get((ExtensionAccessor)this.applicationModel);
            this.applicationContext = springExtensionInjector.getContext();
        }
        if (this.applicationContext == null) {
            return new Status(Status.Level.UNKNOWN);
        }
        Map dataSources = this.applicationContext.getBeansOfType(DataSource.class, false, false);
        if (CollectionUtils.isEmptyMap((Map)dataSources)) {
            return new Status(Status.Level.UNKNOWN);
        }
        Status.Level level = Status.Level.OK;
        StringBuilder buf = new StringBuilder();
        for (Map.Entry entry : dataSources.entrySet()) {
            DataSource dataSource = (DataSource)entry.getValue();
            if (buf.length() > 0) {
                buf.append(", ");
            }
            buf.append((String)entry.getKey());
            try {
                Connection connection = dataSource.getConnection();
                Throwable throwable = null;
                try {
                    DatabaseMetaData metaData = connection.getMetaData();
                    try (ResultSet resultSet = metaData.getTypeInfo();){
                        if (!resultSet.next()) {
                            level = Status.Level.ERROR;
                        }
                    }
                    buf.append(metaData.getURL());
                    buf.append('(');
                    buf.append(metaData.getDatabaseProductName());
                    buf.append('-');
                    buf.append(metaData.getDatabaseProductVersion());
                    buf.append(')');
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (connection == null) continue;
                    if (throwable != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    connection.close();
                }
            }
            catch (Throwable e) {
                logger.warn("5-31", "", "", e.getMessage(), e);
                return new Status(level, e.getMessage());
            }
        }
        return new Status(level, buf.toString());
    }
}

