/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.spring.beans.factory.annotation;

import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.dubbo.common.compact.Dubbo2CompactUtils;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.AnnotationUtils;
import org.apache.dubbo.common.utils.ArrayUtils;
import org.apache.dubbo.common.utils.Assert;
import org.apache.dubbo.common.utils.ClassUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.Reference;
import org.apache.dubbo.config.spring.ReferenceBean;
import org.apache.dubbo.config.spring.beans.factory.annotation.AbstractAnnotationBeanPostProcessor;
import org.apache.dubbo.config.spring.context.event.DubboConfigInitEvent;
import org.apache.dubbo.config.spring.reference.ReferenceBeanManager;
import org.apache.dubbo.config.spring.reference.ReferenceBeanSupport;
import org.apache.dubbo.config.spring.util.SpringCompatUtils;
import org.apache.dubbo.rpc.service.GenericService;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.annotation.InjectionMetadata;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.MethodMetadata;
import org.springframework.util.StringUtils;

public class ReferenceAnnotationBeanPostProcessor
extends AbstractAnnotationBeanPostProcessor
implements ApplicationContextAware,
BeanFactoryPostProcessor {
    public static final String BEAN_NAME = "referenceAnnotationBeanPostProcessor";
    private static final int CACHE_SIZE = Integer.getInteger("referenceAnnotationBeanPostProcessor.cache.size", 32);
    private final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(this.getClass());
    private final ConcurrentMap<InjectionMetadata.InjectedElement, String> injectedFieldReferenceBeanCache = new ConcurrentHashMap<InjectionMetadata.InjectedElement, String>(CACHE_SIZE);
    private final ConcurrentMap<InjectionMetadata.InjectedElement, String> injectedMethodReferenceBeanCache = new ConcurrentHashMap<InjectionMetadata.InjectedElement, String>(CACHE_SIZE);
    private ApplicationContext applicationContext;
    private ReferenceBeanManager referenceBeanManager;
    private BeanDefinitionRegistry beanDefinitionRegistry;

    public ReferenceAnnotationBeanPostProcessor() {
        super(ReferenceAnnotationBeanPostProcessor.loadAnnotationTypes());
    }

    private static Class<? extends Annotation>[] loadAnnotationTypes() {
        if (Dubbo2CompactUtils.isEnabled() && Dubbo2CompactUtils.isReferenceClassLoaded()) {
            return new Class[]{DubboReference.class, Reference.class, Dubbo2CompactUtils.getReferenceClass()};
        }
        return new Class[]{DubboReference.class, Reference.class};
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        String[] beanNames;
        for (String beanName : beanNames = beanFactory.getBeanDefinitionNames()) {
            Class beanType;
            if (beanFactory.isFactoryBean(beanName)) {
                BeanDefinition beanDefinition = beanFactory.getBeanDefinition(beanName);
                if (this.isReferenceBean(beanDefinition)) continue;
                if (this.isAnnotatedReferenceBean(beanDefinition)) {
                    this.processReferenceAnnotatedBeanDefinition(beanName, (AnnotatedBeanDefinition)beanDefinition);
                    continue;
                }
                String beanClassName = beanDefinition.getBeanClassName();
                beanType = ClassUtils.resolveClass((String)beanClassName, (ClassLoader)this.getClassLoader());
            } else {
                beanType = beanFactory.getType(beanName);
            }
            if (beanType == null) continue;
            AbstractAnnotationBeanPostProcessor.AnnotatedInjectionMetadata metadata = this.findInjectionMetadata(beanName, beanType, null);
            try {
                this.prepareInjection(metadata);
            }
            catch (BeansException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IllegalStateException("Prepare dubbo reference injection element failed", e);
            }
        }
        if (beanFactory instanceof AbstractBeanFactory) {
            List beanPostProcessors = ((AbstractBeanFactory)beanFactory).getBeanPostProcessors();
            for (BeanPostProcessor beanPostProcessor : beanPostProcessors) {
                if (beanPostProcessor != this) continue;
                this.beanDefinitionRegistry.removeBeanDefinition(BEAN_NAME);
                break;
            }
        }
        try {
            this.applicationContext.publishEvent((ApplicationEvent)new DubboConfigInitEvent(this.applicationContext));
        }
        catch (Exception e) {
            this.logger.warn("5-39", "", "", "publish early application event failed, please upgrade spring version to 4.2.x or later: " + e);
        }
    }

    private boolean isAnnotatedReferenceBean(BeanDefinition beanDefinition) {
        AnnotatedBeanDefinition annotatedBeanDefinition;
        String beanClassName;
        return beanDefinition instanceof AnnotatedBeanDefinition && (beanClassName = SpringCompatUtils.getFactoryMethodReturnType(annotatedBeanDefinition = (AnnotatedBeanDefinition)beanDefinition)) != null && ReferenceBean.class.getName().equals(beanClassName);
    }

    private void processReferenceAnnotatedBeanDefinition(String beanName, AnnotatedBeanDefinition beanDefinition) {
        MethodMetadata factoryMethodMetadata = SpringCompatUtils.getFactoryMethodMetadata(beanDefinition);
        Class beanClass = this.getBeanFactory().getType(beanName);
        if (beanClass == Object.class) {
            beanClass = SpringCompatUtils.getGenericTypeOfReturnType(factoryMethodMetadata);
        }
        if (beanClass == Object.class) {
            return;
        }
        if (beanClass == null) {
            String beanMethodSignature = factoryMethodMetadata.getDeclaringClassName() + "#" + factoryMethodMetadata.getMethodName() + "()";
            throw new BeanCreationException("The ReferenceBean is missing necessary generic type, which returned by the @Bean method of Java-config class. The generic type of the returned ReferenceBean must be specified as the referenced interface type, such as ReferenceBean<DemoService>. Please check bean method: " + beanMethodSignature);
        }
        Map annotationAttributes = null;
        for (Class<? extends Annotation> annotationType : this.getAnnotationTypes()) {
            if (!factoryMethodMetadata.isAnnotated(annotationType.getName())) continue;
            annotationAttributes = factoryMethodMetadata.getAnnotationAttributes(annotationType.getName());
            annotationAttributes = AnnotationUtils.filterDefaultValues(annotationType, (Map)annotationAttributes);
            break;
        }
        if (annotationAttributes != null) {
            LinkedHashMap<String, Object> attributes = new LinkedHashMap<String, Object>(annotationAttributes);
            attributes.put("id", beanName);
            ReferenceBeanSupport.convertReferenceProps(attributes, beanClass);
            String interfaceName = (String)attributes.get("interface");
            if (!org.apache.dubbo.common.utils.StringUtils.isEquals((String)interfaceName, (String)beanClass.getName()) && beanClass != GenericService.class) {
                String beanMethodSignature = factoryMethodMetadata.getDeclaringClassName() + "#" + factoryMethodMetadata.getMethodName() + "()";
                throw new BeanCreationException("The 'interfaceClass' or 'interfaceName' attribute value of @DubboReference annotation is inconsistent with the generic type of the ReferenceBean returned by the bean method. The interface class of @DubboReference is: " + interfaceName + ", but return ReferenceBean<" + beanClass.getName() + ">. Please remove the 'interfaceClass' and 'interfaceName' attributes from @DubboReference annotation. Please check bean method: " + beanMethodSignature);
            }
            Class interfaceClass = beanClass;
            beanDefinition.setAttribute("referenceProps", attributes);
            beanDefinition.setAttribute("interfaceClass", (Object)interfaceClass);
            beanDefinition.setAttribute("interfaceName", (Object)interfaceName);
        } else {
            beanDefinition.setAttribute("interfaceClass", (Object)beanClass);
            if (beanClass != GenericService.class) {
                beanDefinition.setAttribute("interfaceName", (Object)beanClass.getName());
            }
        }
        beanDefinition.getPropertyValues().add("id", (Object)beanName);
    }

    public void postProcessMergedBeanDefinition(RootBeanDefinition beanDefinition, Class<?> beanType, String beanName) {
        if (beanType != null) {
            if (this.isReferenceBean((BeanDefinition)beanDefinition)) {
                List propertyValues = beanDefinition.getPropertyValues().getPropertyValueList();
                for (PropertyValue propertyValue : propertyValues) {
                    propertyValue.setOptional(true);
                }
            } else if (!this.isAnnotatedReferenceBean((BeanDefinition)beanDefinition)) {
                AbstractAnnotationBeanPostProcessor.AnnotatedInjectionMetadata metadata = this.findInjectionMetadata(beanName, beanType, null);
                metadata.checkConfigMembers(beanDefinition);
                try {
                    this.prepareInjection(metadata);
                }
                catch (Exception e) {
                    throw new IllegalStateException("Prepare dubbo reference injection element failed", e);
                }
            }
        }
    }

    public PropertyValues postProcessPropertyValues(PropertyValues pvs, PropertyDescriptor[] pds, Object bean, String beanName) throws BeansException {
        return this.postProcessProperties(pvs, bean, beanName);
    }

    public PropertyValues postProcessProperties(PropertyValues pvs, Object bean, String beanName) throws BeansException {
        try {
            AbstractAnnotationBeanPostProcessor.AnnotatedInjectionMetadata metadata = this.findInjectionMetadata(beanName, bean.getClass(), pvs);
            this.prepareInjection(metadata);
            metadata.inject(bean, beanName, pvs);
        }
        catch (BeansException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new BeanCreationException(beanName, "Injection of @" + this.getAnnotationType().getSimpleName() + " dependencies is failed", ex);
        }
        return pvs;
    }

    private boolean isReferenceBean(BeanDefinition beanDefinition) {
        return ReferenceBean.class.getName().equals(beanDefinition.getBeanClassName());
    }

    @Override
    protected void prepareInjection(AbstractAnnotationBeanPostProcessor.AnnotatedInjectionMetadata metadata) throws BeansException {
        try {
            String referenceBeanName;
            AnnotationAttributes attributes;
            Class<?> injectedType;
            for (AbstractAnnotationBeanPostProcessor.AnnotatedFieldElement fieldElement : metadata.getFieldElements()) {
                if (fieldElement.injectedObject != null) continue;
                injectedType = fieldElement.field.getType();
                attributes = fieldElement.attributes;
                referenceBeanName = this.registerReferenceBean(fieldElement.getPropertyName(), injectedType, (Map<String, Object>)attributes, fieldElement.field);
                fieldElement.injectedObject = referenceBeanName;
                this.injectedFieldReferenceBeanCache.put(fieldElement, referenceBeanName);
            }
            for (AbstractAnnotationBeanPostProcessor.AnnotatedMethodElement methodElement : metadata.getMethodElements()) {
                if (methodElement.injectedObject != null) continue;
                injectedType = methodElement.getInjectedType();
                attributes = methodElement.attributes;
                referenceBeanName = this.registerReferenceBean(methodElement.getPropertyName(), injectedType, (Map<String, Object>)attributes, methodElement.method);
                methodElement.injectedObject = referenceBeanName;
                this.injectedMethodReferenceBeanCache.put(methodElement, referenceBeanName);
            }
        }
        catch (ClassNotFoundException e) {
            throw new BeanCreationException("prepare reference annotation failed", (Throwable)e);
        }
    }

    public String registerReferenceBean(String propertyName, Class<?> injectedType, Map<String, Object> attributes, Member member) throws BeansException {
        boolean renameable = true;
        String referenceBeanName = (String)org.apache.dubbo.config.spring.util.AnnotationUtils.getAttribute(attributes, "id");
        if (StringUtils.hasText((String)referenceBeanName)) {
            renameable = false;
        } else {
            referenceBeanName = propertyName;
        }
        String checkLocation = "Please check " + member.toString();
        ReferenceBeanSupport.convertReferenceProps(attributes, injectedType);
        String interfaceName = (String)attributes.get("interface");
        if (org.apache.dubbo.common.utils.StringUtils.isBlank((CharSequence)interfaceName)) {
            throw new BeanCreationException("Need to specify the 'interfaceName' or 'interfaceClass' attribute of '@DubboReference' if enable generic. " + checkLocation);
        }
        String referenceKey = ReferenceBeanSupport.generateReferenceKey(attributes, this.applicationContext);
        List<String> registeredReferenceBeanNames = this.referenceBeanManager.getBeanNamesByKey(referenceKey);
        if (registeredReferenceBeanNames.size() > 0 && registeredReferenceBeanNames.contains(referenceBeanName)) {
            return referenceBeanName;
        }
        boolean isContains = this.beanDefinitionRegistry.containsBeanDefinition(referenceBeanName);
        if (isContains || this.beanDefinitionRegistry.isAlias(referenceBeanName)) {
            Object[] aliases;
            Object preReferenceBeanName = referenceBeanName;
            if (!isContains && ArrayUtils.isNotEmpty((Object[])(aliases = this.beanDefinitionRegistry.getAliases(referenceBeanName)))) {
                for (Object alias : aliases) {
                    if (!this.beanDefinitionRegistry.containsBeanDefinition((String)alias)) continue;
                    preReferenceBeanName = alias;
                    break;
                }
            }
            BeanDefinition prevBeanDefinition = this.beanDefinitionRegistry.getBeanDefinition((String)preReferenceBeanName);
            String prevBeanType = prevBeanDefinition.getBeanClassName();
            String prevBeanDesc = referenceBeanName + "[" + prevBeanType + "]";
            String newBeanDesc = referenceBeanName + "[" + referenceKey + "]";
            if (this.isReferenceBean(prevBeanDefinition)) {
                String prevReferenceKey = ReferenceBeanSupport.generateReferenceKey(prevBeanDefinition, this.applicationContext);
                if (org.apache.dubbo.common.utils.StringUtils.isEquals((String)prevReferenceKey, (String)referenceKey)) {
                    return referenceBeanName;
                }
                Assert.notNull((Object)prevBeanDefinition, (String)"The interface class of ReferenceBean is not initialized");
                prevBeanDesc = referenceBeanName + "[" + prevReferenceKey + "]";
            }
            if (!renameable) {
                throw new BeanCreationException("Already exists another bean definition with the same bean name [" + referenceBeanName + "], but cannot rename the reference bean name (specify the id attribute or java-config bean), please modify the name of one of the beans: prev: " + prevBeanDesc + ", new: " + newBeanDesc + ". " + checkLocation);
            }
            int index = 2;
            String newReferenceBeanName = null;
            while (newReferenceBeanName == null || this.beanDefinitionRegistry.containsBeanDefinition(newReferenceBeanName) || this.beanDefinitionRegistry.isAlias(newReferenceBeanName)) {
                newReferenceBeanName = referenceBeanName + "#" + index;
                ++index;
                if (!registeredReferenceBeanNames.contains(newReferenceBeanName)) continue;
                return newReferenceBeanName;
            }
            newBeanDesc = newReferenceBeanName + "[" + referenceKey + "]";
            this.logger.warn("5-39", "", "", "Already exists another bean definition with the same bean name [" + referenceBeanName + "], rename dubbo reference bean to [" + newReferenceBeanName + "]. It is recommended to modify the name of one of the beans to avoid injection problems. prev: " + prevBeanDesc + ", new: " + newBeanDesc + ". " + checkLocation);
            referenceBeanName = newReferenceBeanName;
        }
        attributes.put("id", referenceBeanName);
        if (registeredReferenceBeanNames.size() > 0) {
            this.beanDefinitionRegistry.registerAlias(registeredReferenceBeanNames.get(0), referenceBeanName);
            this.referenceBeanManager.registerReferenceKeyAndBeanName(referenceKey, referenceBeanName);
            return referenceBeanName;
        }
        Class<?> interfaceClass = injectedType;
        RootBeanDefinition beanDefinition = new RootBeanDefinition();
        beanDefinition.setBeanClassName(ReferenceBean.class.getName());
        beanDefinition.getPropertyValues().add("id", (Object)referenceBeanName);
        beanDefinition.setAttribute("referenceProps", attributes);
        beanDefinition.setAttribute("interfaceClass", interfaceClass);
        beanDefinition.setAttribute("interfaceName", (Object)interfaceName);
        GenericBeanDefinition targetDefinition = new GenericBeanDefinition();
        targetDefinition.setBeanClass(interfaceClass);
        beanDefinition.setDecoratedDefinition(new BeanDefinitionHolder((BeanDefinition)targetDefinition, referenceBeanName + "_decorated"));
        beanDefinition.setAttribute("factoryBeanObjectType", interfaceClass);
        this.beanDefinitionRegistry.registerBeanDefinition(referenceBeanName, (BeanDefinition)beanDefinition);
        this.referenceBeanManager.registerReferenceKeyAndBeanName(referenceKey, referenceBeanName);
        this.logger.info("Register dubbo reference bean: " + referenceBeanName + " = " + referenceKey + " at " + member);
        return referenceBeanName;
    }

    @Override
    protected Object doGetInjectedBean(AnnotationAttributes attributes, Object bean, String beanName, Class<?> injectedType, AbstractAnnotationBeanPostProcessor.AnnotatedInjectElement injectedElement) throws Exception {
        if (injectedElement.injectedObject == null) {
            throw new IllegalStateException("The AnnotatedInjectElement of @DubboReference should be inited before injection");
        }
        return this.getBeanFactory().getBean((String)injectedElement.injectedObject);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
        this.referenceBeanManager = (ReferenceBeanManager)applicationContext.getBean("dubboReferenceBeanManager", ReferenceBeanManager.class);
        this.beanDefinitionRegistry = (BeanDefinitionRegistry)applicationContext.getAutowireCapableBeanFactory();
    }

    @Override
    public void destroy() throws Exception {
        super.destroy();
        this.injectedFieldReferenceBeanCache.clear();
        this.injectedMethodReferenceBeanCache.clear();
    }

    @Deprecated
    public Collection<ReferenceBean<?>> getReferenceBeans() {
        return Collections.emptyList();
    }

    public Map<InjectionMetadata.InjectedElement, ReferenceBean<?>> getInjectedFieldReferenceBeanMap() {
        HashMap map = new HashMap();
        for (Map.Entry entry : this.injectedFieldReferenceBeanCache.entrySet()) {
            map.put(entry.getKey(), this.referenceBeanManager.getById((String)entry.getValue()));
        }
        return Collections.unmodifiableMap(map);
    }

    public Map<InjectionMetadata.InjectedElement, ReferenceBean<?>> getInjectedMethodReferenceBeanMap() {
        HashMap map = new HashMap();
        for (Map.Entry entry : this.injectedMethodReferenceBeanCache.entrySet()) {
            map.put(entry.getKey(), this.referenceBeanManager.getById((String)entry.getValue()));
        }
        return Collections.unmodifiableMap(map);
    }
}

