/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.spring.context;

import org.apache.dubbo.config.spring.beans.factory.annotation.ReferenceAnnotationBeanPostProcessor;
import org.apache.dubbo.config.spring.util.DubboBeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class DubboInfraBeanRegisterPostProcessor
implements BeanDefinitionRegistryPostProcessor,
ApplicationContextAware {
    public static final String BEAN_NAME = "dubboInfraBeanRegisterPostProcessor";
    private BeanDefinitionRegistry registry;
    private ApplicationContext applicationContext;

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
        this.registry = registry;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        if (this.registry != null) {
            ReferenceAnnotationBeanPostProcessor referenceAnnotationBeanPostProcessor = (ReferenceAnnotationBeanPostProcessor)beanFactory.getBean(ReferenceAnnotationBeanPostProcessor.BEAN_NAME, ReferenceAnnotationBeanPostProcessor.class);
            beanFactory.addBeanPostProcessor((BeanPostProcessor)referenceAnnotationBeanPostProcessor);
            DubboBeanUtils.registerPlaceholderConfigurerBeanIfNotExists(beanFactory, this.registry);
        }
        if (this.registry != null) {
            this.registry.removeBeanDefinition(BEAN_NAME);
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

