/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.spring.context;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.config.spring.context.DubboConfigBeanInitializer;
import org.apache.dubbo.config.spring.context.event.DubboConfigInitEvent;
import org.apache.dubbo.config.spring.util.DubboBeanUtils;
import org.apache.dubbo.rpc.model.ModuleModel;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;
import org.springframework.util.ObjectUtils;

public class DubboConfigApplicationListener
implements ApplicationListener<DubboConfigInitEvent>,
ApplicationContextAware {
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(DubboConfigApplicationListener.class);
    private ApplicationContext applicationContext;
    private ModuleModel moduleModel;
    private final AtomicBoolean initialized = new AtomicBoolean();

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
        this.moduleModel = DubboBeanUtils.getModuleModel((BeanFactory)applicationContext);
    }

    public void onApplicationEvent(DubboConfigInitEvent event) {
        if (ObjectUtils.nullSafeEquals((Object)this.applicationContext, (Object)event.getSource())) {
            this.init();
        }
    }

    public synchronized void init() {
        if (this.initialized.compareAndSet(false, true)) {
            this.initDubboConfigBeans();
        }
    }

    private void initDubboConfigBeans() {
        if (this.applicationContext.containsBean(DubboConfigBeanInitializer.BEAN_NAME)) {
            this.applicationContext.getBean(DubboConfigBeanInitializer.BEAN_NAME, DubboConfigBeanInitializer.class);
        } else {
            logger.warn("5-40", "", "", "Bean '" + DubboConfigBeanInitializer.BEAN_NAME + "' was not found");
        }
        this.moduleModel.getDeployer().prepare();
    }
}

