/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.spring.context.annotation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.dubbo.config.spring.context.annotation.ConfigurationBeanBindingRegistrar;
import org.apache.dubbo.config.spring.context.config.ConfigurationBeanBinder;
import org.apache.dubbo.config.spring.context.config.ConfigurationBeanCustomizer;
import org.apache.dubbo.config.spring.context.config.DefaultConfigurationBeanBinder;
import org.apache.dubbo.config.spring.util.WrapperUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.core.PriorityOrdered;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

public class ConfigurationBeanBindingPostProcessor
implements BeanPostProcessor,
BeanFactoryAware,
PriorityOrdered {
    public static final String BEAN_NAME = "configurationBeanBindingPostProcessor";
    static final String CONFIGURATION_PROPERTIES_ATTRIBUTE_NAME = "configurationProperties";
    static final String IGNORE_UNKNOWN_FIELDS_ATTRIBUTE_NAME = "ignoreUnknownFields";
    static final String IGNORE_INVALID_FIELDS_ATTRIBUTE_NAME = "ignoreInvalidFields";
    private final Log log = LogFactory.getLog(this.getClass());
    private ConfigurableListableBeanFactory beanFactory = null;
    private ConfigurationBeanBinder configurationBeanBinder = null;
    private List<ConfigurationBeanCustomizer> configurationBeanCustomizers = null;
    private int order = Integer.MAX_VALUE;

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        BeanDefinition beanDefinition = this.getNullableBeanDefinition(beanName);
        if (this.isConfigurationBean(bean, beanDefinition)) {
            this.bindConfigurationBean(bean, beanDefinition);
            this.customize(beanName, bean);
        }
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public ConfigurationBeanBinder getConfigurationBeanBinder() {
        if (this.configurationBeanBinder == null) {
            this.initConfigurationBeanBinder();
        }
        return this.configurationBeanBinder;
    }

    public void setConfigurationBeanBinder(ConfigurationBeanBinder configurationBeanBinder) {
        this.configurationBeanBinder = configurationBeanBinder;
    }

    public List<ConfigurationBeanCustomizer> getConfigurationBeanCustomizers() {
        if (this.configurationBeanCustomizers == null) {
            this.initBindConfigurationBeanCustomizers();
        }
        return this.configurationBeanCustomizers;
    }

    public void setConfigurationBeanCustomizers(Collection<ConfigurationBeanCustomizer> configurationBeanCustomizers) {
        ArrayList<ConfigurationBeanCustomizer> customizers = new ArrayList<ConfigurationBeanCustomizer>(configurationBeanCustomizers);
        AnnotationAwareOrderComparator.sort(customizers);
        this.configurationBeanCustomizers = Collections.unmodifiableList(customizers);
    }

    private BeanDefinition getNullableBeanDefinition(String beanName) {
        return this.beanFactory.containsBeanDefinition(beanName) ? this.beanFactory.getBeanDefinition(beanName) : null;
    }

    private boolean isConfigurationBean(Object bean, BeanDefinition beanDefinition) {
        return beanDefinition != null && ConfigurationBeanBindingRegistrar.ENABLE_CONFIGURATION_BINDING_CLASS.equals(beanDefinition.getSource()) && ObjectUtils.nullSafeEquals((Object)this.getBeanClassName(bean), (Object)beanDefinition.getBeanClassName());
    }

    private String getBeanClassName(Object bean) {
        return ClassUtils.getUserClass(bean.getClass()).getName();
    }

    private void bindConfigurationBean(Object configurationBean, BeanDefinition beanDefinition) {
        Map<String, Object> configurationProperties = ConfigurationBeanBindingPostProcessor.getConfigurationProperties(beanDefinition);
        boolean ignoreUnknownFields = ConfigurationBeanBindingPostProcessor.getIgnoreUnknownFields(beanDefinition);
        boolean ignoreInvalidFields = ConfigurationBeanBindingPostProcessor.getIgnoreInvalidFields(beanDefinition);
        this.getConfigurationBeanBinder().bind(configurationProperties, ignoreUnknownFields, ignoreInvalidFields, configurationBean);
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)("The configuration bean [" + configurationBean + "] have been binding by the configuration properties [" + configurationProperties + "]"));
        }
    }

    private void initConfigurationBeanBinder() {
        if (this.configurationBeanBinder == null) {
            try {
                this.configurationBeanBinder = (ConfigurationBeanBinder)this.beanFactory.getBean(ConfigurationBeanBinder.class);
            }
            catch (BeansException ignored) {
                if (this.log.isInfoEnabled()) {
                    this.log.info((Object)"configurationBeanBinder Bean can't be found in ApplicationContext.");
                }
                this.configurationBeanBinder = this.defaultConfigurationBeanBinder();
            }
        }
    }

    private void initBindConfigurationBeanCustomizers() {
        Collection<ConfigurationBeanCustomizer> customizers = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.beanFactory, ConfigurationBeanCustomizer.class).values();
        this.setConfigurationBeanCustomizers(customizers);
    }

    private void customize(String beanName, Object configurationBean) {
        for (ConfigurationBeanCustomizer customizer : this.getConfigurationBeanCustomizers()) {
            customizer.customize(beanName, configurationBean);
        }
    }

    private ConfigurationBeanBinder defaultConfigurationBeanBinder() {
        return new DefaultConfigurationBeanBinder();
    }

    static void initBeanMetadataAttributes(AbstractBeanDefinition beanDefinition, Map<String, Object> configurationProperties, boolean ignoreUnknownFields, boolean ignoreInvalidFields) {
        beanDefinition.setAttribute(CONFIGURATION_PROPERTIES_ATTRIBUTE_NAME, configurationProperties);
        beanDefinition.setAttribute(IGNORE_UNKNOWN_FIELDS_ATTRIBUTE_NAME, (Object)ignoreUnknownFields);
        beanDefinition.setAttribute(IGNORE_INVALID_FIELDS_ATTRIBUTE_NAME, (Object)ignoreInvalidFields);
    }

    private static <T> T getAttribute(BeanDefinition beanDefinition, String attributeName) {
        return (T)beanDefinition.getAttribute(attributeName);
    }

    private static Map<String, Object> getConfigurationProperties(BeanDefinition beanDefinition) {
        return (Map)ConfigurationBeanBindingPostProcessor.getAttribute(beanDefinition, CONFIGURATION_PROPERTIES_ATTRIBUTE_NAME);
    }

    private static boolean getIgnoreUnknownFields(BeanDefinition beanDefinition) {
        return (Boolean)ConfigurationBeanBindingPostProcessor.getAttribute(beanDefinition, IGNORE_UNKNOWN_FIELDS_ATTRIBUTE_NAME);
    }

    private static boolean getIgnoreInvalidFields(BeanDefinition beanDefinition) {
        return (Boolean)ConfigurationBeanBindingPostProcessor.getAttribute(beanDefinition, IGNORE_INVALID_FIELDS_ATTRIBUTE_NAME);
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = WrapperUtils.unwrap(beanFactory);
    }

    public int getOrder() {
        return this.order;
    }
}

