/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.spring6.utils;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import org.apache.dubbo.common.compiler.support.ClassUtils;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.TypeReference;

public class AotUtils {
    private AotUtils() {
    }

    public static void registerSerializationForService(Class<?> serviceType, RuntimeHints hints) {
        Arrays.stream(serviceType.getMethods()).forEach(method -> {
            Arrays.stream(method.getParameterTypes()).forEach(parameterType -> AotUtils.registerSerializationType(parameterType, hints));
            AotUtils.registerSerializationType(method.getReturnType(), hints);
        });
    }

    private static void registerSerializationType(Class<?> registerType, RuntimeHints hints) {
        if (AotUtils.isPrimitive(registerType)) {
            hints.serialization().registerType(TypeReference.of((Class)ClassUtils.getBoxedClass(registerType)));
        } else if (Serializable.class.isAssignableFrom(registerType)) {
            hints.serialization().registerType(TypeReference.of(registerType));
            Arrays.stream(registerType.getDeclaredFields()).forEach(field -> AotUtils.registerSerializationType(field.getType(), hints));
            AotUtils.registerSerializationType(registerType.getSuperclass(), hints);
        }
    }

    private static boolean isPrimitive(Class<?> cls) {
        return cls.isPrimitive() || cls == Boolean.class || cls == Byte.class || cls == Character.class || cls == Short.class || cls == Integer.class || cls == Long.class || cls == Float.class || cls == Double.class || cls == String.class || cls == Date.class || cls == Class.class;
    }
}

