/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.configcenter.support.apollo;

import com.ctrip.framework.apollo.Config;
import com.ctrip.framework.apollo.ConfigChangeListener;
import com.ctrip.framework.apollo.ConfigFile;
import com.ctrip.framework.apollo.ConfigService;
import com.ctrip.framework.apollo.core.enums.ConfigFileFormat;
import com.ctrip.framework.apollo.enums.ConfigSourceType;
import com.ctrip.framework.apollo.enums.PropertyChangeType;
import com.ctrip.framework.apollo.model.ConfigChange;
import com.ctrip.framework.apollo.model.ConfigChangeEvent;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.stream.Collectors;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.config.configcenter.ConfigChangeType;
import org.apache.dubbo.common.config.configcenter.ConfigChangedEvent;
import org.apache.dubbo.common.config.configcenter.ConfigurationListener;
import org.apache.dubbo.common.config.configcenter.DynamicConfiguration;
import org.apache.dubbo.common.constants.CommonConstants;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.common.utils.SystemPropertyConfigUtils;
import org.apache.dubbo.metrics.config.event.ConfigCenterEvent;
import org.apache.dubbo.metrics.event.MetricsEvent;
import org.apache.dubbo.metrics.event.MetricsEventBus;
import org.apache.dubbo.rpc.model.ApplicationModel;

public class ApolloDynamicConfiguration
implements DynamicConfiguration {
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(ApolloDynamicConfiguration.class);
    private static final String APOLLO_PROTOCOL_PREFIX = "http://";
    private static final String APOLLO_APPLICATION_KEY = "application";
    private final URL url;
    private final Config dubboConfig;
    private final ConfigFile dubboConfigFile;
    private final ConcurrentMap<String, ApolloListener> listeners = new ConcurrentHashMap<String, ApolloListener>();
    private final ApplicationModel applicationModel;

    ApolloDynamicConfiguration(URL url, ApplicationModel applicationModel) {
        String namespace;
        this.url = url;
        this.applicationModel = applicationModel;
        String configEnv = url.getParameter("env");
        String configAddr = this.getAddressWithProtocolPrefix(url);
        String configCluster = url.getParameter("cluster");
        String configAppId = url.getParameter("app.id");
        if (StringUtils.isEmpty((String)SystemPropertyConfigUtils.getSystemProperty((String)"env")) && configEnv != null) {
            SystemPropertyConfigUtils.getSystemProperty((String)"env", (String)configEnv);
        }
        if (StringUtils.isEmpty((String)SystemPropertyConfigUtils.getSystemProperty((String)"apollo.meta")) && !"0.0.0.0".equals(url.getHost())) {
            SystemPropertyConfigUtils.setSystemProperty((String)"apollo.meta", (String)configAddr);
        }
        if (StringUtils.isEmpty((String)SystemPropertyConfigUtils.getSystemProperty((String)"apollo.cluster")) && configCluster != null) {
            SystemPropertyConfigUtils.getSystemProperty((String)"apollo.cluster", (String)configCluster);
        }
        if (StringUtils.isEmpty((String)SystemPropertyConfigUtils.getSystemProperty((String)"app.id")) && configAppId != null) {
            SystemPropertyConfigUtils.getSystemProperty((String)"app.id", (String)configAppId);
        }
        String apolloNamespace = StringUtils.isEmpty((String)(namespace = url.getParameter("namespace", "dubbo"))) ? url.getGroup("dubbo") : namespace;
        this.dubboConfig = ConfigService.getConfig((String)apolloNamespace);
        this.dubboConfigFile = ConfigService.getConfigFile((String)apolloNamespace, (ConfigFileFormat)ConfigFileFormat.Properties);
        boolean check = url.getParameter("check", true);
        if (this.dubboConfig.getSourceType() != ConfigSourceType.REMOTE) {
            if (check) {
                throw new IllegalStateException("Failed to connect to config center, the config center is Apollo, the address is: " + (StringUtils.isNotEmpty((String)configAddr) ? configAddr : configEnv));
            }
            logger.warn("5-1", "configuration server offline", "", "Failed to connect to config center, the config center is Apollo, the address is: " + (StringUtils.isNotEmpty((String)configAddr) ? configAddr : configEnv) + ", will use the local cache value instead before eventually the connection is established.");
        }
    }

    public void close() {
        try {
            this.listeners.clear();
        }
        catch (UnsupportedOperationException e) {
            logger.warn("5-32", "", "", "Failed to close connect from config center, the config center is Apollo");
        }
    }

    private String getAddressWithProtocolPrefix(URL url) {
        String address = url.getBackupAddress();
        if (StringUtils.isNotEmpty((String)address)) {
            address = Arrays.stream(CommonConstants.COMMA_SPLIT_PATTERN.split(address)).map(addr -> {
                if (addr.startsWith(APOLLO_PROTOCOL_PREFIX)) {
                    return addr;
                }
                return APOLLO_PROTOCOL_PREFIX + addr;
            }).collect(Collectors.joining(","));
        }
        return address;
    }

    public void addListener(String key, String group, ConfigurationListener listener) {
        ApolloListener apolloListener = this.listeners.computeIfAbsent(group + key, k -> this.createTargetListener(key, group));
        apolloListener.addListener(listener);
        this.dubboConfig.addChangeListener((ConfigChangeListener)apolloListener, Collections.singleton(key));
    }

    public void removeListener(String key, String group, ConfigurationListener listener) {
        ApolloListener apolloListener = (ApolloListener)this.listeners.get(group + key);
        if (apolloListener != null) {
            apolloListener.removeListener(listener);
            if (!apolloListener.hasInternalListener()) {
                this.dubboConfig.removeChangeListener((ConfigChangeListener)apolloListener);
            }
        }
    }

    public String getConfig(String key, String group, long timeout) throws IllegalStateException {
        if (StringUtils.isNotEmpty((String)group)) {
            if (group.equals(this.url.getApplication())) {
                return ConfigService.getAppConfig().getProperty(key, null);
            }
            return ConfigService.getConfig((String)group).getProperty(key, null);
        }
        return this.dubboConfig.getProperty(key, null);
    }

    public String getProperties(String key, String group, long timeout) throws IllegalStateException {
        if (StringUtils.isEmpty((String)group)) {
            return this.dubboConfigFile.getContent();
        }
        if (group.equals(this.url.getApplication())) {
            return ConfigService.getConfigFile((String)APOLLO_APPLICATION_KEY, (ConfigFileFormat)ConfigFileFormat.Properties).getContent();
        }
        ConfigFile configFile = ConfigService.getConfigFile((String)group, (ConfigFileFormat)ConfigFileFormat.Properties);
        if (configFile == null) {
            throw new IllegalStateException("There is no namespace named " + group + " in Apollo.");
        }
        return configFile.getContent();
    }

    public String getInternalProperty(String key) {
        return this.dubboConfig.getProperty(key, null);
    }

    private ApolloListener createTargetListener(String key, String group) {
        return new ApolloListener();
    }

    public class ApolloListener
    implements ConfigChangeListener {
        private Set<ConfigurationListener> listeners = new CopyOnWriteArraySet<ConfigurationListener>();

        ApolloListener() {
        }

        public void onChange(ConfigChangeEvent changeEvent) {
            for (String key : changeEvent.changedKeys()) {
                ConfigChange change = changeEvent.getChange(key);
                if ("".equals(change.getNewValue())) {
                    logger.warn("5-33", "", "", "an empty rule is received for " + key + ", the current working rule is " + change.getOldValue() + ", the empty rule will not take effect.");
                    return;
                }
                ConfigChangedEvent event = new ConfigChangedEvent(key, change.getNamespace(), change.getNewValue(), this.getChangeType(change));
                this.listeners.forEach(listener -> listener.process(event));
                MetricsEventBus.publish((MetricsEvent)ConfigCenterEvent.toChangeEvent((ApplicationModel)ApolloDynamicConfiguration.this.applicationModel, (String)event.getKey(), (String)event.getGroup(), (String)"apollo", (String)ConfigChangeType.ADDED.name(), (int)1));
            }
        }

        private ConfigChangeType getChangeType(ConfigChange change) {
            if (change.getChangeType() == PropertyChangeType.DELETED) {
                return ConfigChangeType.DELETED;
            }
            return ConfigChangeType.MODIFIED;
        }

        void addListener(ConfigurationListener configurationListener) {
            this.listeners.add(configurationListener);
        }

        void removeListener(ConfigurationListener configurationListener) {
            this.listeners.remove(configurationListener);
        }

        boolean hasInternalListener() {
            return this.listeners != null && this.listeners.size() > 0;
        }
    }
}

