/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.configcenter.support.zookeeper;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.utils.NamedThreadFactory;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.configcenter.ConfigurationListener;
import org.apache.dubbo.configcenter.DynamicConfiguration;
import org.apache.dubbo.configcenter.support.zookeeper.CacheListener;
import org.apache.dubbo.remoting.zookeeper.DataListener;
import org.apache.dubbo.remoting.zookeeper.ZookeeperClient;
import org.apache.dubbo.remoting.zookeeper.ZookeeperTransporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZookeeperDynamicConfiguration
implements DynamicConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(ZookeeperDynamicConfiguration.class);
    private Executor executor;
    private String rootPath;
    private final ZookeeperClient zkClient;
    private CountDownLatch initializedLatch;
    private CacheListener cacheListener;
    private URL url;

    ZookeeperDynamicConfiguration(URL url, ZookeeperTransporter zookeeperTransporter) {
        this.url = url;
        this.rootPath = "/" + url.getParameter("namespace", "dubbo") + "/config";
        this.initializedLatch = new CountDownLatch(1);
        this.cacheListener = new CacheListener(this.rootPath, this.initializedLatch);
        this.executor = Executors.newFixedThreadPool(1, (ThreadFactory)new NamedThreadFactory(this.getClass().getSimpleName(), true));
        this.zkClient = zookeeperTransporter.connect(url);
        this.zkClient.addDataListener(this.rootPath, (DataListener)this.cacheListener, this.executor);
        try {
            long timeout = url.getParameter("init.timeout", 5000);
            boolean isCountDown = this.initializedLatch.await(timeout, TimeUnit.MILLISECONDS);
            if (!isCountDown) {
                throw new IllegalStateException("Failed to receive INITIALIZED event from zookeeper, pls. check if url " + url + " is correct");
            }
        }
        catch (InterruptedException e) {
            logger.warn("Failed to build local cache for config center (zookeeper)." + url);
        }
    }

    public Object getInternalProperty(String key) {
        return this.zkClient.getContent(key);
    }

    public void addListener(String key, String group, ConfigurationListener listener) {
        this.cacheListener.addListener(this.getPathKey(group, key), listener);
    }

    public void removeListener(String key, String group, ConfigurationListener listener) {
        this.cacheListener.removeListener(this.getPathKey(group, key), listener);
    }

    public String getRule(String key, String group, long timeout) throws IllegalStateException {
        return (String)this.getInternalProperty(this.getPathKey(group, key));
    }

    public String getProperties(String key, String group, long timeout) throws IllegalStateException {
        if (StringUtils.isEmpty((String)group)) {
            group = "dubbo";
        }
        return (String)this.getInternalProperty(this.getPathKey(group, key));
    }

    private String getPathKey(String group, String key) {
        return this.rootPath + "/" + group + "/" + key;
    }
}

