/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.configcenter.support.zookeeper;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.config.configcenter.ConfigItem;
import org.apache.dubbo.common.config.configcenter.ConfigurationListener;
import org.apache.dubbo.common.config.configcenter.TreePathDynamicConfiguration;
import org.apache.dubbo.common.threadpool.support.AbortPolicyWithReport;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.NamedThreadFactory;
import org.apache.dubbo.configcenter.support.zookeeper.CacheListener;
import org.apache.dubbo.configcenter.support.zookeeper.ZookeeperDataListener;
import org.apache.dubbo.remoting.zookeeper.DataListener;
import org.apache.dubbo.remoting.zookeeper.ZookeeperClient;
import org.apache.dubbo.remoting.zookeeper.ZookeeperTransporter;
import org.apache.zookeeper.data.Stat;

public class ZookeeperDynamicConfiguration
extends TreePathDynamicConfiguration {
    private Executor executor;
    private ZookeeperClient zkClient;
    private CacheListener cacheListener = new CacheListener();
    private static final int DEFAULT_ZK_EXECUTOR_THREADS_NUM = 1;
    private static final int DEFAULT_QUEUE = 10000;
    private static final Long THREAD_KEEP_ALIVE_TIME = 0L;

    ZookeeperDynamicConfiguration(URL url, ZookeeperTransporter zookeeperTransporter) {
        super(url);
        String threadName = ((Object)((Object)this)).getClass().getSimpleName();
        this.executor = new ThreadPoolExecutor(1, 1, THREAD_KEEP_ALIVE_TIME, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(10000), (ThreadFactory)new NamedThreadFactory(threadName, true), (RejectedExecutionHandler)new AbortPolicyWithReport(threadName, url));
        this.zkClient = zookeeperTransporter.connect(url);
        boolean isConnected = this.zkClient.isConnected();
        if (!isConnected) {
            IllegalStateException illegalStateException = new IllegalStateException("Failed to connect with zookeeper, pls check if url " + url + " is correct.");
            if (this.logger != null) {
                this.logger.error("5-1", "configuration server offline", "", "Failed to connect with zookeeper", (Throwable)illegalStateException);
            }
            throw illegalStateException;
        }
    }

    public String getInternalProperty(String key) {
        return this.zkClient.getContent(this.buildPathKey("", key));
    }

    protected void doClose() throws Exception {
        Map<String, ZookeeperDataListener> pathKeyListeners = this.cacheListener.getPathKeyListeners();
        for (Map.Entry<String, ZookeeperDataListener> entry : pathKeyListeners.entrySet()) {
            this.zkClient.removeDataListener(entry.getKey(), (DataListener)entry.getValue());
        }
        this.cacheListener.clear();
        this.zkClient = null;
    }

    protected boolean doPublishConfig(String pathKey, String content) throws Exception {
        this.zkClient.create(pathKey, content, false);
        return true;
    }

    public boolean publishConfigCas(String key, String group, String content, Object ticket) {
        try {
            if (ticket != null && !(ticket instanceof Stat)) {
                throw new IllegalArgumentException("zookeeper publishConfigCas requires stat type ticket");
            }
            String pathKey = this.buildPathKey(group, key);
            this.zkClient.createOrUpdate(pathKey, content, false, ticket == null ? 0 : ((Stat)ticket).getVersion());
            return true;
        }
        catch (Exception e) {
            this.logger.warn("zookeeper publishConfigCas failed.", (Throwable)e);
            return false;
        }
    }

    protected String doGetConfig(String pathKey) throws Exception {
        return this.zkClient.getContent(pathKey);
    }

    public ConfigItem getConfigItem(String key, String group) {
        String pathKey = this.buildPathKey(group, key);
        return this.zkClient.getConfigItem(pathKey);
    }

    protected boolean doRemoveConfig(String pathKey) throws Exception {
        this.zkClient.delete(pathKey);
        return true;
    }

    protected Collection<String> doGetConfigKeys(String groupPath) {
        return this.zkClient.getChildren(groupPath);
    }

    protected void doAddListener(String pathKey, ConfigurationListener listener, String key, String group) {
        ZookeeperDataListener cachedListener = this.cacheListener.getCachedListener(pathKey);
        if (cachedListener != null) {
            cachedListener.addListener(listener);
        } else {
            ZookeeperDataListener addedListener = this.cacheListener.addListener(pathKey, listener, key, group);
            this.zkClient.addDataListener(pathKey, (DataListener)addedListener, this.executor);
        }
    }

    protected void doRemoveListener(String pathKey, ConfigurationListener listener) {
        ZookeeperDataListener zookeeperDataListener = this.cacheListener.removeListener(pathKey, listener);
        if (zookeeperDataListener != null && CollectionUtils.isEmpty(zookeeperDataListener.getListeners())) {
            this.zkClient.removeDataListener(pathKey, (DataListener)zookeeperDataListener);
        }
    }
}

