/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.maven.plugin.aot;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.dubbo.maven.plugin.aot.AbstractAotMojo;
import org.apache.dubbo.maven.plugin.aot.AbstractDependencyFilterMojo;
import org.apache.dubbo.maven.plugin.aot.RunArguments;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.shared.artifact.filter.collection.ArtifactsFilter;

@Mojo(name="dubbo-process-aot", defaultPhase=LifecyclePhase.PREPARE_PACKAGE, threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class DubboProcessAotMojo
extends AbstractAotMojo {
    private static final String AOT_PROCESSOR_CLASS_NAME = "org.apache.dubbo.aot.generate.AotProcessor";
    @Parameter(defaultValue="${project.build.outputDirectory}", required=true)
    private File classesDirectory;
    @Parameter(defaultValue="${project.build.directory}/dubbo-aot/main/sources", required=true)
    private File generatedSources;
    @Parameter(defaultValue="${project.build.directory}/dubbo-aot/main/resources", required=true)
    private File generatedResources;
    @Parameter(defaultValue="${project.build.directory}/dubbo-aot/main/classes", required=true)
    private File generatedClasses;
    @Parameter(property="dubbo.aot.main-class")
    private String mainClass;
    @Parameter
    private String[] arguments;

    @Override
    protected void executeAot() throws Exception {
        URL[] classPath = this.getClassPath().toArray(new URL[0]);
        this.generateAotAssets(classPath, AOT_PROCESSOR_CLASS_NAME, this.getAotArguments(this.mainClass));
        this.compileSourceFiles(classPath, this.generatedSources, this.classesDirectory);
        this.copyAll(this.generatedResources.toPath(), this.classesDirectory.toPath());
        this.copyAll(this.generatedClasses.toPath(), this.classesDirectory.toPath());
    }

    private String[] getAotArguments(String applicationClass) {
        ArrayList<String> aotArguments = new ArrayList<String>();
        aotArguments.add(applicationClass);
        aotArguments.add(this.generatedSources.toString());
        aotArguments.add(this.generatedResources.toString());
        aotArguments.add(this.generatedClasses.toString());
        aotArguments.add(this.project.getGroupId());
        aotArguments.add(this.project.getArtifactId());
        aotArguments.addAll(new RunArguments(this.arguments).getArgs());
        return aotArguments.toArray(new String[0]);
    }

    private List<URL> getClassPath() throws Exception {
        File[] directories = new File[]{this.classesDirectory, this.generatedClasses};
        return this.getClassPath(directories, new ArtifactsFilter[]{new AbstractDependencyFilterMojo.ExcludeTestScopeArtifactFilter()});
    }
}

