/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metadata.rest.springmvc;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.dubbo.common.utils.AnnotationUtils;
import org.apache.dubbo.common.utils.ArrayUtils;
import org.apache.dubbo.common.utils.PathUtils;
import org.apache.dubbo.metadata.rest.AbstractServiceRestMetadataResolver;

public class SpringMvcServiceRestMetadataResolver
extends AbstractServiceRestMetadataResolver {
    private static final int FIRST_ELEMENT_INDEX = 0;

    @Override
    protected boolean supports0(Class<?> serviceType) {
        return AnnotationUtils.isAnnotationPresent(serviceType, (String)"org.springframework.stereotype.Controller");
    }

    @Override
    protected boolean isRestCapableMethod(Method serviceMethod, Class<?> serviceType, Class<?> serviceInterfaceClass) {
        return AnnotationUtils.isAnnotationPresent(serviceType, (String)"org.springframework.web.bind.annotation.RequestMapping");
    }

    @Override
    protected String resolveRequestMethod(Method serviceMethod, Class<?> serviceType, Class<?> serviceInterfaceClass) {
        String requestBasePath = this.resolveRequestPath(serviceType);
        String requestRelativePath = this.resolveRequestPath(serviceMethod);
        return PathUtils.buildPath((String)requestBasePath, (String[])new String[]{requestRelativePath});
    }

    @Override
    protected String resolveRequestPath(Method serviceMethod, Class<?> serviceType, Class<?> serviceInterfaceClass) {
        Annotation requestMapping = this.getRequestMapping(serviceMethod);
        Object httpMethod = AnnotationUtils.getAttribute((Annotation)requestMapping, (String)"method");
        if (httpMethod == null || Array.getLength(httpMethod) < 1) {
            return null;
        }
        return String.valueOf(Array.get(httpMethod, 0));
    }

    @Override
    protected void processProduces(Method serviceMethod, Class<?> serviceType, Class<?> serviceInterfaceClass, Set<String> produces) {
        this.addMediaTypes(serviceMethod, "produces", produces);
    }

    @Override
    protected void processConsumes(Method serviceMethod, Class<?> serviceType, Class<?> serviceInterfaceClass, Set<String> consumes) {
        this.addMediaTypes(serviceMethod, "consumes", consumes);
    }

    private String resolveRequestPath(AnnotatedElement annotatedElement) {
        Annotation mappingAnnotation = this.getRequestMapping(annotatedElement);
        Object[] value = (String[])AnnotationUtils.getAttribute((Annotation)mappingAnnotation, (String)"value");
        if (ArrayUtils.isEmpty((Object[])value)) {
            value = (String[])AnnotationUtils.getAttribute((Annotation)mappingAnnotation, (String)"path");
        }
        if (ArrayUtils.isEmpty((Object[])value)) {
            return "";
        }
        return value[0];
    }

    private void addMediaTypes(Method serviceMethod, String annotationAttributeName, Set<String> mediaTypesSet) {
        Annotation mappingAnnotation = this.getRequestMapping(serviceMethod);
        Object[] mediaTypes = (String[])AnnotationUtils.getAttribute((Annotation)mappingAnnotation, (String)annotationAttributeName);
        if (ArrayUtils.isNotEmpty((Object[])mediaTypes)) {
            Stream.of(mediaTypes).forEach(mediaTypesSet::add);
        }
    }

    private Annotation getRequestMapping(AnnotatedElement annotatedElement) {
        Annotation requestMapping = AnnotationUtils.findAnnotation((AnnotatedElement)annotatedElement, (String)"org.springframework.web.bind.annotation.RequestMapping");
        if (requestMapping == null) {
            requestMapping = AnnotationUtils.findMetaAnnotation((AnnotatedElement)annotatedElement, (String)"org.springframework.web.bind.annotation.RequestMapping");
        }
        return requestMapping;
    }
}

