/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metadata.rest;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import org.apache.dubbo.common.function.ThrowableAction;
import org.apache.dubbo.metadata.rest.ServiceRestMetadata;
import org.apache.dubbo.metadata.rest.ServiceRestMetadataReader;

public class ClassPathServiceRestMetadataReader
implements ServiceRestMetadataReader {
    private final String serviceRestMetadataJsonResoucePath;

    public ClassPathServiceRestMetadataReader() {
        this("META-INF/dubbo/service-rest-metadata.json");
    }

    public ClassPathServiceRestMetadataReader(String serviceRestMetadataJsonResoucePath) {
        this.serviceRestMetadataJsonResoucePath = serviceRestMetadataJsonResoucePath;
    }

    @Override
    public List<ServiceRestMetadata> read() {
        LinkedList serviceRestMetadataList = new LinkedList();
        ClassLoader classLoader = this.getClass().getClassLoader();
        ThrowableAction.execute(() -> {
            Enumeration<URL> resources = classLoader.getResources(this.serviceRestMetadataJsonResoucePath);
            Gson gson = new Gson();
            while (resources.hasMoreElements()) {
                JsonParser parser = new JsonParser();
                URL resource = resources.nextElement();
                InputStream inputStream = resource.openStream();
                JsonElement jsonElement = parser.parse((Reader)new InputStreamReader(inputStream, "UTF-8"));
                if (!jsonElement.isJsonArray()) continue;
                JsonArray jsonArray = jsonElement.getAsJsonArray();
                for (int i = 0; i < jsonArray.size(); ++i) {
                    JsonElement childJsonElement = jsonArray.get(i);
                    ServiceRestMetadata serviceRestMetadata = (ServiceRestMetadata)gson.fromJson(childJsonElement, ServiceRestMetadata.class);
                    serviceRestMetadataList.add(serviceRestMetadata);
                }
            }
        });
        return Collections.unmodifiableList(serviceRestMetadataList);
    }
}

